/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class WorldGenSettingsFix
extends DataFix {
    private static final String VILLAGE = "minecraft:village";
    private static final String DESERT_PYRAMID = "minecraft:desert_pyramid";
    private static final String IGLOO = "minecraft:igloo";
    private static final String JUNGLE_TEMPLE = "minecraft:jungle_pyramid";
    private static final String SWAMP_HUT = "minecraft:swamp_hut";
    private static final String PILLAGER_OUTPOST = "minecraft:pillager_outpost";
    private static final String END_CITY = "minecraft:endcity";
    private static final String WOODLAND_MANSION = "minecraft:mansion";
    private static final String OCEAN_MONUMENT = "minecraft:monument";
    private static final ImmutableMap<String, StructureFeatureConfiguration> DEFAULTS = ImmutableMap.builder().put((Object)"minecraft:village", (Object)new StructureFeatureConfiguration(32, 8, 10387312)).put((Object)"minecraft:desert_pyramid", (Object)new StructureFeatureConfiguration(32, 8, 14357617)).put((Object)"minecraft:igloo", (Object)new StructureFeatureConfiguration(32, 8, 14357618)).put((Object)"minecraft:jungle_pyramid", (Object)new StructureFeatureConfiguration(32, 8, 14357619)).put((Object)"minecraft:swamp_hut", (Object)new StructureFeatureConfiguration(32, 8, 14357620)).put((Object)"minecraft:pillager_outpost", (Object)new StructureFeatureConfiguration(32, 8, 165745296)).put((Object)"minecraft:monument", (Object)new StructureFeatureConfiguration(32, 5, 10387313)).put((Object)"minecraft:endcity", (Object)new StructureFeatureConfiguration(20, 11, 10387313)).put((Object)"minecraft:mansion", (Object)new StructureFeatureConfiguration(80, 20, 10387319)).build();

    public WorldGenSettingsFix(Schema var0) {
        super(var0, true);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("WorldGenSettings building", this.getInputSchema().getType(References.WORLD_GEN_SETTINGS), var0 -> var0.update(DSL.remainderFinder(), WorldGenSettingsFix::fix));
    }

    private static <T> Dynamic<T> noise(long var0, DynamicLike<T> var2, Dynamic<T> var3, Dynamic<T> var4) {
        return var2.createMap((Map)ImmutableMap.of((Object)var2.createString("type"), (Object)var2.createString("minecraft:noise"), (Object)var2.createString("biome_source"), var4, (Object)var2.createString("seed"), (Object)var2.createLong(var0), (Object)var2.createString("settings"), var3));
    }

    private static <T> Dynamic<T> vanillaBiomeSource(Dynamic<T> var0, long var1, boolean var3, boolean var4) {
        ImmutableMap.Builder var5 = ImmutableMap.builder().put((Object)var0.createString("type"), (Object)var0.createString("minecraft:vanilla_layered")).put((Object)var0.createString("seed"), (Object)var0.createLong(var1)).put((Object)var0.createString("large_biomes"), (Object)var0.createBoolean(var4));
        if (var3) {
            var5.put((Object)var0.createString("legacy_biome_init_layer"), (Object)var0.createBoolean(var3));
        }
        return var0.createMap((Map)var5.build());
    }

    private static <T> Dynamic<T> fix(Dynamic<T> var02) {
        OptionalDynamic var10;
        Dynamic<T> var4;
        DynamicOps var1 = var02.getOps();
        long var2 = var02.get("RandomSeed").asLong(0L);
        Optional var5 = var02.get("generatorName").asString().map(var0 -> var0.toLowerCase(Locale.ROOT)).result();
        Optional var6 = var02.get("legacy_custom_options").asString().result().map(Optional::of).orElseGet(() -> {
            if (var5.equals(Optional.of("customized"))) {
                return var02.get("generatorOptions").asString().result();
            }
            return Optional.empty();
        });
        boolean var7 = false;
        if (var5.equals(Optional.of("customized"))) {
            var4 = WorldGenSettingsFix.defaultOverworld(var02, var2);
        } else if (var5.isEmpty()) {
            var4 = WorldGenSettingsFix.defaultOverworld(var02, var2);
        } else {
            switch ((String)var5.get()) {
                case "flat": {
                    var10 = var02.get("generatorOptions");
                    Map<Dynamic<T>, Dynamic<T>> var11 = WorldGenSettingsFix.fixFlatStructures(var1, var10);
                    var4 = var02.createMap((Map)ImmutableMap.of((Object)var02.createString("type"), (Object)var02.createString("minecraft:flat"), (Object)var02.createString("settings"), (Object)var02.createMap((Map)ImmutableMap.of((Object)var02.createString("structures"), (Object)var02.createMap(var11), (Object)var02.createString("layers"), (Object)var10.get("layers").result().orElseGet(() -> var02.createList(Stream.of(var02.createMap((Map)ImmutableMap.of((Object)var02.createString("height"), (Object)var02.createInt(1), (Object)var02.createString("block"), (Object)var02.createString("minecraft:bedrock"))), var02.createMap((Map)ImmutableMap.of((Object)var02.createString("height"), (Object)var02.createInt(2), (Object)var02.createString("block"), (Object)var02.createString("minecraft:dirt"))), var02.createMap((Map)ImmutableMap.of((Object)var02.createString("height"), (Object)var02.createInt(1), (Object)var02.createString("block"), (Object)var02.createString("minecraft:grass_block")))))), (Object)var02.createString("biome"), (Object)var02.createString(var10.get("biome").asString("minecraft:plains"))))));
                    break;
                }
                case "debug_all_block_states": {
                    var4 = var02.createMap((Map)ImmutableMap.of((Object)var02.createString("type"), (Object)var02.createString("minecraft:debug")));
                    break;
                }
                case "buffet": {
                    Dynamic var17;
                    Dynamic var15;
                    OptionalDynamic var12 = var02.get("generatorOptions");
                    OptionalDynamic var13 = var12.get("chunk_generator");
                    Optional var14 = var13.get("type").asString().result();
                    if (Objects.equals(var14, Optional.of("minecraft:caves"))) {
                        var15 = var02.createString("minecraft:caves");
                        var7 = true;
                    } else {
                        var15 = Objects.equals(var14, Optional.of("minecraft:floating_islands")) ? var02.createString("minecraft:floating_islands") : var02.createString("minecraft:overworld");
                    }
                    Dynamic var16 = var12.get("biome_source").result().orElseGet(() -> var02.createMap((Map)ImmutableMap.of((Object)var02.createString("type"), (Object)var02.createString("minecraft:fixed"))));
                    if (var16.get("type").asString().result().equals(Optional.of("minecraft:fixed"))) {
                        String var18 = var16.get("options").get("biomes").asStream().findFirst().flatMap(var0 -> var0.asString().result()).orElse("minecraft:ocean");
                        var17 = var16.remove("options").set("biome", var02.createString(var18));
                    } else {
                        var17 = var16;
                    }
                    var4 = WorldGenSettingsFix.noise(var2, var02, var15, var17);
                    break;
                }
                default: {
                    boolean var18 = ((String)var5.get()).equals("default");
                    boolean var19 = ((String)var5.get()).equals("default_1_1") || var18 && var02.get("generatorVersion").asInt(0) == 0;
                    boolean var20 = ((String)var5.get()).equals("amplified");
                    boolean var21 = ((String)var5.get()).equals("largebiomes");
                    var4 = WorldGenSettingsFix.noise(var2, var02, var02.createString(var20 ? "minecraft:amplified" : "minecraft:overworld"), WorldGenSettingsFix.vanillaBiomeSource(var02, var2, var19, var21));
                }
            }
        }
        boolean var8 = var02.get("MapFeatures").asBoolean(true);
        boolean var9 = var02.get("BonusChest").asBoolean(false);
        var10 = ImmutableMap.builder();
        var10.put(var1.createString("seed"), var1.createLong(var2));
        var10.put(var1.createString("generate_features"), var1.createBoolean(var8));
        var10.put(var1.createString("bonus_chest"), var1.createBoolean(var9));
        var10.put(var1.createString("dimensions"), WorldGenSettingsFix.vanillaLevels(var02, var2, var4, var7));
        var6.ifPresent(arg_0 -> WorldGenSettingsFix.lambda$fix$6((ImmutableMap.Builder)var10, var1, arg_0));
        return new Dynamic(var1, var1.createMap((Map)var10.build()));
    }

    protected static <T> Dynamic<T> defaultOverworld(Dynamic<T> var0, long var1) {
        return WorldGenSettingsFix.noise(var1, var0, var0.createString("minecraft:overworld"), WorldGenSettingsFix.vanillaBiomeSource(var0, var1, false, false));
    }

    protected static <T> T vanillaLevels(Dynamic<T> var0, long var1, Dynamic<T> var3, boolean var4) {
        DynamicOps var5 = var0.getOps();
        return (T)var5.createMap((Map)ImmutableMap.of((Object)var5.createString("minecraft:overworld"), (Object)var5.createMap((Map)ImmutableMap.of((Object)var5.createString("type"), (Object)var5.createString("minecraft:overworld" + (var4 ? "_caves" : "")), (Object)var5.createString("generator"), (Object)var3.getValue())), (Object)var5.createString("minecraft:the_nether"), (Object)var5.createMap((Map)ImmutableMap.of((Object)var5.createString("type"), (Object)var5.createString("minecraft:the_nether"), (Object)var5.createString("generator"), (Object)WorldGenSettingsFix.noise(var1, var0, var0.createString("minecraft:nether"), var0.createMap((Map)ImmutableMap.of((Object)var0.createString("type"), (Object)var0.createString("minecraft:multi_noise"), (Object)var0.createString("seed"), (Object)var0.createLong(var1), (Object)var0.createString("preset"), (Object)var0.createString("minecraft:nether")))).getValue())), (Object)var5.createString("minecraft:the_end"), (Object)var5.createMap((Map)ImmutableMap.of((Object)var5.createString("type"), (Object)var5.createString("minecraft:the_end"), (Object)var5.createString("generator"), (Object)WorldGenSettingsFix.noise(var1, var0, var0.createString("minecraft:end"), var0.createMap((Map)ImmutableMap.of((Object)var0.createString("type"), (Object)var0.createString("minecraft:the_end"), (Object)var0.createString("seed"), (Object)var0.createLong(var1)))).getValue()))));
    }

    private static <T> Map<Dynamic<T>, Dynamic<T>> fixFlatStructures(DynamicOps<T> var0, OptionalDynamic<T> var12) {
        MutableInt var2 = new MutableInt(32);
        MutableInt var3 = new MutableInt(3);
        MutableInt var4 = new MutableInt(128);
        MutableBoolean var5 = new MutableBoolean(false);
        HashMap var6 = Maps.newHashMap();
        if (var12.result().isEmpty()) {
            var5.setTrue();
            var6.put(VILLAGE, (StructureFeatureConfiguration)DEFAULTS.get((Object)VILLAGE));
        }
        var12.get("structures").flatMap(Dynamic::getMapValues).ifSuccess(var52 -> var52.forEach((var5, var6) -> var6.getMapValues().result().ifPresent(var62 -> var62.forEach((var6, var7) -> {
            String var8 = var5.asString("");
            String var9 = var6.asString("");
            String var10 = var7.asString("");
            if ("stronghold".equals(var8)) {
                var5.setTrue();
                switch (var9) {
                    case "distance": {
                        var2.setValue(WorldGenSettingsFix.getInt(var10, var2.intValue(), 1));
                        return;
                    }
                    case "spread": {
                        var3.setValue(WorldGenSettingsFix.getInt(var10, var3.intValue(), 1));
                        return;
                    }
                    case "count": {
                        var4.setValue(WorldGenSettingsFix.getInt(var10, var4.intValue(), 1));
                        return;
                    }
                }
                return;
            }
            switch (var9) {
                case "distance": {
                    switch (var8) {
                        case "village": {
                            WorldGenSettingsFix.setSpacing(var6, VILLAGE, var10, 9);
                            return;
                        }
                        case "biome_1": {
                            WorldGenSettingsFix.setSpacing(var6, DESERT_PYRAMID, var10, 9);
                            WorldGenSettingsFix.setSpacing(var6, IGLOO, var10, 9);
                            WorldGenSettingsFix.setSpacing(var6, JUNGLE_TEMPLE, var10, 9);
                            WorldGenSettingsFix.setSpacing(var6, SWAMP_HUT, var10, 9);
                            WorldGenSettingsFix.setSpacing(var6, PILLAGER_OUTPOST, var10, 9);
                            return;
                        }
                        case "endcity": {
                            WorldGenSettingsFix.setSpacing(var6, END_CITY, var10, 1);
                            return;
                        }
                        case "mansion": {
                            WorldGenSettingsFix.setSpacing(var6, WOODLAND_MANSION, var10, 1);
                            return;
                        }
                    }
                    return;
                }
                case "separation": {
                    if ("oceanmonument".equals(var8)) {
                        StructureFeatureConfiguration var13 = var6.getOrDefault(OCEAN_MONUMENT, (StructureFeatureConfiguration)DEFAULTS.get((Object)OCEAN_MONUMENT));
                        int var14 = WorldGenSettingsFix.getInt(var10, var13.separation, 1);
                        var6.put(OCEAN_MONUMENT, new StructureFeatureConfiguration(var14, var13.separation, var13.salt));
                    }
                    return;
                }
                case "spacing": {
                    if ("oceanmonument".equals(var8)) {
                        WorldGenSettingsFix.setSpacing(var6, OCEAN_MONUMENT, var10, 1);
                    }
                    return;
                }
            }
        }))));
        ImmutableMap.Builder var7 = ImmutableMap.builder();
        var7.put((Object)var12.createString("structures"), (Object)var12.createMap(var6.entrySet().stream().collect(Collectors.toMap(var1 -> var12.createString((String)var1.getKey()), var1 -> ((StructureFeatureConfiguration)var1.getValue()).serialize(var0)))));
        if (var5.isTrue()) {
            var7.put((Object)var12.createString("stronghold"), (Object)var12.createMap((Map)ImmutableMap.of((Object)var12.createString("distance"), (Object)var12.createInt(var2.intValue()), (Object)var12.createString("spread"), (Object)var12.createInt(var3.intValue()), (Object)var12.createString("count"), (Object)var12.createInt(var4.intValue()))));
        }
        return var7.build();
    }

    private static int getInt(String var0, int var1) {
        return NumberUtils.toInt((String)var0, (int)var1);
    }

    private static int getInt(String var0, int var1, int var2) {
        return Math.max(var2, WorldGenSettingsFix.getInt(var0, var1));
    }

    private static void setSpacing(Map<String, StructureFeatureConfiguration> var0, String var1, String var2, int var3) {
        StructureFeatureConfiguration var4 = var0.getOrDefault(var1, (StructureFeatureConfiguration)DEFAULTS.get((Object)var1));
        int var5 = WorldGenSettingsFix.getInt(var2, var4.spacing, var3);
        var0.put(var1, new StructureFeatureConfiguration(var5, var4.separation, var4.salt));
    }

    private static /* synthetic */ void lambda$fix$6(ImmutableMap.Builder var0, DynamicOps var1, String var2) {
        var0.put(var1.createString("legacy_custom_options"), var1.createString(var2));
    }

    static final class StructureFeatureConfiguration {
        public static final Codec<StructureFeatureConfiguration> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.INT.fieldOf("spacing").forGetter(var0 -> var0.spacing), (App)Codec.INT.fieldOf("separation").forGetter(var0 -> var0.separation), (App)Codec.INT.fieldOf("salt").forGetter(var0 -> var0.salt)).apply((Applicative)var02, StructureFeatureConfiguration::new));
        final int spacing;
        final int separation;
        final int salt;

        public StructureFeatureConfiguration(int var0, int var1, int var2) {
            this.spacing = var0;
            this.separation = var1;
            this.salt = var2;
        }

        public <T> Dynamic<T> serialize(DynamicOps<T> var0) {
            return new Dynamic(var0, CODEC.encodeStart(var0, (Object)this).result().orElse(var0.emptyMap()));
        }
    }
}

