/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debug;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotProvider;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.schedule.Activity;
import org.jspecify.annotations.Nullable;

public record DebugBrainDump(String name, String profession, int xp, float health, float maxHealth, String inventory, boolean wantsGolem, int angerLevel, List<String> activities, List<String> behaviors, List<String> memories, List<String> gossips, Set<BlockPos> pois, Set<BlockPos> potentialPois) {
    public static final StreamCodec<FriendlyByteBuf, DebugBrainDump> STREAM_CODEC = StreamCodec.of((var0, var1) -> var1.write((FriendlyByteBuf)((Object)var0)), DebugBrainDump::new);

    public DebugBrainDump(FriendlyByteBuf var0) {
        this(var0.readUtf(), var0.readUtf(), var0.readInt(), var0.readFloat(), var0.readFloat(), var0.readUtf(), var0.readBoolean(), var0.readInt(), var0.readList(FriendlyByteBuf::readUtf), var0.readList(FriendlyByteBuf::readUtf), var0.readList(FriendlyByteBuf::readUtf), var0.readList(FriendlyByteBuf::readUtf), var0.readCollection(HashSet::new, BlockPos.STREAM_CODEC), var0.readCollection(HashSet::new, BlockPos.STREAM_CODEC));
    }

    public void write(FriendlyByteBuf var0) {
        var0.writeUtf(this.name);
        var0.writeUtf(this.profession);
        var0.writeInt(this.xp);
        var0.writeFloat(this.health);
        var0.writeFloat(this.maxHealth);
        var0.writeUtf(this.inventory);
        var0.writeBoolean(this.wantsGolem);
        var0.writeInt(this.angerLevel);
        var0.writeCollection(this.activities, FriendlyByteBuf::writeUtf);
        var0.writeCollection(this.behaviors, FriendlyByteBuf::writeUtf);
        var0.writeCollection(this.memories, FriendlyByteBuf::writeUtf);
        var0.writeCollection(this.gossips, FriendlyByteBuf::writeUtf);
        var0.writeCollection(this.pois, BlockPos.STREAM_CODEC);
        var0.writeCollection(this.potentialPois, BlockPos.STREAM_CODEC);
    }

    public static DebugBrainDump takeBrainDump(ServerLevel var02, LivingEntity var1) {
        List<String> list;
        int n;
        Object var13;
        InventoryCarrier var11;
        SlotProvider var12;
        int var4;
        String var3;
        String var2 = DebugEntityNameGenerator.getEntityName(var1);
        if (var1 instanceof Villager) {
            Villager var5 = (Villager)var1;
            var3 = var5.getVillagerData().profession().getRegisteredName();
            var4 = var5.getVillagerXp();
        } else {
            var3 = "";
            var4 = 0;
        }
        float var5 = var1.getHealth();
        float var6 = var1.getMaxHealth();
        Brain<?> var7 = var1.getBrain();
        long var8 = var1.level().getGameTime();
        String var10 = var1 instanceof InventoryCarrier ? ((var12 = (var11 = (InventoryCarrier)((Object)var1)).getInventory()).isEmpty() ? "" : var12.toString()) : "";
        boolean bl = var11 = var1 instanceof Villager && ((Villager)(var12 = (Villager)var1)).wantsToSpawnGolem(var8);
        if (var1 instanceof Warden) {
            var13 = (Warden)var1;
            n = ((Warden)var13).getClientAngerLevel();
        } else {
            n = -1;
        }
        int var20 = n;
        var13 = var7.getActiveActivities().stream().map(Activity::getName).toList();
        List<String> var14 = var7.getRunningBehaviors().stream().map(BehaviorControl::debugString).toList();
        List<String> var15 = DebugBrainDump.getMemoryDescriptions(var02, var1, var8).map(var0 -> StringUtil.truncateStringIfNecessary(var0, 255, true)).toList();
        Set<BlockPos> var16 = DebugBrainDump.getKnownBlockPositions(var7, MemoryModuleType.JOB_SITE, MemoryModuleType.HOME, MemoryModuleType.MEETING_POINT);
        Set<BlockPos> var17 = DebugBrainDump.getKnownBlockPositions(var7, MemoryModuleType.POTENTIAL_JOB_SITE);
        if (var1 instanceof Villager) {
            Villager var19 = (Villager)var1;
            list = DebugBrainDump.getVillagerGossips(var19);
        } else {
            list = List.of();
        }
        List<String> var18 = list;
        return new DebugBrainDump(var2, var3, var4, var5, var6, var10, var11, var20, (List<String>)var13, var14, var15, var18, var16, var17);
    }

    @SafeVarargs
    private static Set<BlockPos> getKnownBlockPositions(Brain<?> var0, MemoryModuleType<GlobalPos> ... var1) {
        return Stream.of(var1).filter(var0::hasMemoryValue).map(var0::getMemory).flatMap(Optional::stream).map(GlobalPos::pos).collect(Collectors.toSet());
    }

    private static List<String> getVillagerGossips(Villager var0) {
        ArrayList<String> var12 = new ArrayList<String>();
        var0.getGossips().getGossipEntries().forEach((var1, var22) -> {
            String var32 = DebugEntityNameGenerator.getEntityName(var1);
            var22.forEach((var2, var3) -> var12.add(var32 + ": " + String.valueOf(var2) + ": " + var3));
        });
        return var12;
    }

    private static Stream<String> getMemoryDescriptions(ServerLevel var0, LivingEntity var1, long var2) {
        return var1.getBrain().getMemories().entrySet().stream().map(var3 -> {
            MemoryModuleType var4 = (MemoryModuleType)var3.getKey();
            Optional var5 = (Optional)var3.getValue();
            return DebugBrainDump.getMemoryDescription(var0, var2, var4, var5);
        }).sorted();
    }

    private static String getMemoryDescription(ServerLevel var0, long var1, MemoryModuleType<?> var3, Optional<? extends ExpirableValue<?>> var4) {
        Object var5;
        if (var4.isPresent()) {
            ExpirableValue<?> var6 = var4.get();
            Object var7 = var6.getValue();
            if (var3 == MemoryModuleType.HEARD_BELL_TIME) {
                long var8 = var1 - (Long)var7;
                var5 = var8 + " ticks ago";
            } else {
                var5 = var6.canExpire() ? DebugBrainDump.getShortDescription(var0, var7) + " (ttl: " + var6.getTimeToLive() + ")" : DebugBrainDump.getShortDescription(var0, var7);
            }
        } else {
            var5 = "-";
        }
        return BuiltInRegistries.MEMORY_MODULE_TYPE.getKey(var3).getPath() + ": " + (String)var5;
    }

    private static String getShortDescription(ServerLevel var0, @Nullable Object var12) {
        Object object = var12;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UUID.class, Entity.class, WalkTarget.class, EntityTracker.class, GlobalPos.class, BlockPosTracker.class, DamageSource.class, Collection.class}, (Object)object, n)) {
            case -1 -> "-";
            case 0 -> {
                UUID var4 = (UUID)object;
                yield DebugBrainDump.getShortDescription(var0, var0.getEntity(var4));
            }
            case 1 -> {
                Entity var5 = (Entity)object;
                yield DebugEntityNameGenerator.getEntityName(var5);
            }
            case 2 -> {
                WalkTarget var6 = (WalkTarget)object;
                yield DebugBrainDump.getShortDescription(var0, var6.getTarget());
            }
            case 3 -> {
                EntityTracker var7 = (EntityTracker)object;
                yield DebugBrainDump.getShortDescription(var0, var7.getEntity());
            }
            case 4 -> {
                GlobalPos var8 = (GlobalPos)object;
                yield DebugBrainDump.getShortDescription(var0, var8.pos());
            }
            case 5 -> {
                BlockPosTracker var9 = (BlockPosTracker)object;
                yield DebugBrainDump.getShortDescription(var0, var9.currentBlockPosition());
            }
            case 6 -> {
                DamageSource var10 = (DamageSource)object;
                Entity var11 = var10.getEntity();
                if (var11 == null) {
                    yield var12.toString();
                }
                yield DebugBrainDump.getShortDescription(var0, var11);
            }
            case 7 -> {
                Collection var11 = (Collection)object;
                yield "[" + var11.stream().map(var1 -> DebugBrainDump.getShortDescription(var0, var1)).collect(Collectors.joining(", ")) + "]";
            }
            default -> var12.toString();
        };
    }

    public boolean hasPoi(BlockPos var0) {
        return this.pois.contains(var0);
    }

    public boolean hasPotentialPoi(BlockPos var0) {
        return this.potentialPois.contains(var0);
    }
}

