/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.monitoring.jmx;

import com.mojang.logging.LogUtils;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class MinecraftServerStatistics
implements DynamicMBean {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MinecraftServer server;
    private final MBeanInfo mBeanInfo;
    private final Map<String, AttributeDescription> attributeDescriptionByName = Stream.of(new AttributeDescription("tickTimes", this::getTickTimes, "Historical tick times (ms)", long[].class), new AttributeDescription("averageTickTime", this::getAverageTickTime, "Current average tick time (ms)", Long.TYPE)).collect(Collectors.toMap(var0 -> var0.name, Function.identity()));

    private MinecraftServerStatistics(MinecraftServer var02) {
        this.server = var02;
        MBeanAttributeInfo[] var1 = (MBeanAttributeInfo[])this.attributeDescriptionByName.values().stream().map(AttributeDescription::asMBeanAttributeInfo).toArray(MBeanAttributeInfo[]::new);
        this.mBeanInfo = new MBeanInfo(MinecraftServerStatistics.class.getSimpleName(), "metrics for dedicated server", var1, null, null, new MBeanNotificationInfo[0]);
    }

    public static void registerJmxMonitoring(MinecraftServer var0) {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(new MinecraftServerStatistics(var0), new ObjectName("net.minecraft.server:type=Server"));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException var1) {
            LOGGER.warn("Failed to initialise server as JMX bean", (Throwable)var1);
        }
    }

    private float getAverageTickTime() {
        return this.server.getCurrentSmoothedTickTime();
    }

    private long[] getTickTimes() {
        return this.server.getTickTimesNanos();
    }

    @Override
    public @Nullable Object getAttribute(String var0) {
        AttributeDescription var1 = this.attributeDescriptionByName.get(var0);
        return var1 == null ? null : var1.getter.get();
    }

    @Override
    public void setAttribute(Attribute var0) {
    }

    @Override
    public AttributeList getAttributes(String[] var02) {
        List<Attribute> var1 = Arrays.stream(var02).map(this.attributeDescriptionByName::get).filter(Objects::nonNull).map(var0 -> new Attribute(var0.name, var0.getter.get())).collect(Collectors.toList());
        return new AttributeList(var1);
    }

    @Override
    public AttributeList setAttributes(AttributeList var0) {
        return new AttributeList();
    }

    @Override
    public @Nullable Object invoke(String var0, Object[] var1, String[] var2) {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    static final class AttributeDescription {
        final String name;
        final Supplier<Object> getter;
        private final String description;
        private final Class<?> type;

        AttributeDescription(String var0, Supplier<Object> var1, String var2, Class<?> var3) {
            this.name = var0;
            this.getter = var1;
            this.description = var2;
            this.type = var3;
        }

        private MBeanAttributeInfo asMBeanAttributeInfo() {
            return new MBeanAttributeInfo(this.name, this.type.getSimpleName(), this.description, true, false, false);
        }
    }
}

