/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Rule;

public final class GreedyPatternParseRule
implements Rule<StringReader, String> {
    private final Pattern pattern;
    private final DelayedException<CommandSyntaxException> error;

    public GreedyPatternParseRule(Pattern var0, DelayedException<CommandSyntaxException> var1) {
        this.pattern = var0;
        this.error = var1;
    }

    @Override
    public String parse(ParseState<StringReader> var0) {
        StringReader var1 = var0.input();
        String var2 = var1.getString();
        Matcher var3 = this.pattern.matcher(var2).region(var1.getCursor(), var2.length());
        if (!var3.lookingAt()) {
            var0.errorCollector().store(var0.mark(), this.error);
            return null;
        }
        var1.setCursor(var3.end());
        return var3.group(0);
    }

    @Override
    public /* synthetic */ Object parse(ParseState parseState) {
        return this.parse(parseState);
    }
}

