/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.parse;

import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.ChunkIdentification;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.FpsStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.IoSummary;
import net.minecraft.util.profiling.jfr.stats.PacketIdentification;
import net.minecraft.util.profiling.jfr.stats.StructureGenStat;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;
import org.jspecify.annotations.Nullable;

public class JfrStatsParser {
    private Instant recordingStarted = Instant.EPOCH;
    private Instant recordingEnded = Instant.EPOCH;
    private final List<ChunkGenStat> chunkGenStats = new ArrayList<ChunkGenStat>();
    private final List<StructureGenStat> structureGenStats = new ArrayList<StructureGenStat>();
    private final List<CpuLoadStat> cpuLoadStat = new ArrayList<CpuLoadStat>();
    private final Map<PacketIdentification, MutableCountAndSize> receivedPackets = new HashMap<PacketIdentification, MutableCountAndSize>();
    private final Map<PacketIdentification, MutableCountAndSize> sentPackets = new HashMap<PacketIdentification, MutableCountAndSize>();
    private final Map<ChunkIdentification, MutableCountAndSize> readChunks = new HashMap<ChunkIdentification, MutableCountAndSize>();
    private final Map<ChunkIdentification, MutableCountAndSize> writtenChunks = new HashMap<ChunkIdentification, MutableCountAndSize>();
    private final List<FileIOStat> fileWrites = new ArrayList<FileIOStat>();
    private final List<FileIOStat> fileReads = new ArrayList<FileIOStat>();
    private int garbageCollections;
    private Duration gcTotalDuration = Duration.ZERO;
    private final List<GcHeapStat> gcHeapStats = new ArrayList<GcHeapStat>();
    private final List<ThreadAllocationStat> threadAllocationStats = new ArrayList<ThreadAllocationStat>();
    private final List<FpsStat> fps = new ArrayList<FpsStat>();
    private final List<TickTimeStat> serverTickTimes = new ArrayList<TickTimeStat>();
    private @Nullable Duration worldCreationDuration = null;

    private JfrStatsParser(Stream<RecordedEvent> var0) {
        this.capture(var0);
    }

    public static JfrStatsResult parse(Path var0) {
        JfrStatsResult jfrStatsResult;
        final RecordingFile var1 = new RecordingFile(var0);
        try {
            Iterator<RecordedEvent> var2 = new Iterator<RecordedEvent>(){

                @Override
                public boolean hasNext() {
                    return var1.hasMoreEvents();
                }

                @Override
                public RecordedEvent next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        return var1.readEvent();
                    }
                    catch (IOException var0) {
                        throw new UncheckedIOException(var0);
                    }
                }

                @Override
                public /* synthetic */ Object next() {
                    return this.next();
                }
            };
            Stream<RecordedEvent> var3 = StreamSupport.stream(Spliterators.spliteratorUnknownSize(var2, 1297), false);
            jfrStatsResult = new JfrStatsParser(var3).results();
        }
        catch (Throwable throwable) {
            try {
                try {
                    var1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException var12) {
                throw new UncheckedIOException(var12);
            }
        }
        var1.close();
        return jfrStatsResult;
    }

    private JfrStatsResult results() {
        Duration var0 = Duration.between(this.recordingStarted, this.recordingEnded);
        return new JfrStatsResult(this.recordingStarted, this.recordingEnded, var0, this.worldCreationDuration, this.fps, this.serverTickTimes, this.cpuLoadStat, GcHeapStat.summary(var0, this.gcHeapStats, this.gcTotalDuration, this.garbageCollections), ThreadAllocationStat.summary(this.threadAllocationStats), JfrStatsParser.collectIoStats(var0, this.receivedPackets), JfrStatsParser.collectIoStats(var0, this.sentPackets), JfrStatsParser.collectIoStats(var0, this.writtenChunks), JfrStatsParser.collectIoStats(var0, this.readChunks), FileIOStat.summary(var0, this.fileWrites), FileIOStat.summary(var0, this.fileReads), this.chunkGenStats, this.structureGenStats);
    }

    private void capture(Stream<RecordedEvent> var02) {
        var02.forEach(var0 -> {
            if (var0.getEndTime().isAfter(this.recordingEnded) || this.recordingEnded.equals(Instant.EPOCH)) {
                this.recordingEnded = var0.getEndTime();
            }
            if (var0.getStartTime().isBefore(this.recordingStarted) || this.recordingStarted.equals(Instant.EPOCH)) {
                this.recordingStarted = var0.getStartTime();
            }
            switch (var0.getEventType().getName()) {
                case "minecraft.ChunkGeneration": {
                    this.chunkGenStats.add(ChunkGenStat.from(var0));
                    break;
                }
                case "minecraft.StructureGeneration": {
                    this.structureGenStats.add(StructureGenStat.from(var0));
                    break;
                }
                case "minecraft.LoadWorld": {
                    this.worldCreationDuration = var0.getDuration();
                    break;
                }
                case "minecraft.ClientFps": {
                    this.fps.add(FpsStat.from(var0, "fps"));
                    break;
                }
                case "minecraft.ServerTickTime": {
                    this.serverTickTimes.add(TickTimeStat.from(var0));
                    break;
                }
                case "minecraft.PacketReceived": {
                    this.incrementPacket((RecordedEvent)var0, var0.getInt("bytes"), this.receivedPackets);
                    break;
                }
                case "minecraft.PacketSent": {
                    this.incrementPacket((RecordedEvent)var0, var0.getInt("bytes"), this.sentPackets);
                    break;
                }
                case "minecraft.ChunkRegionRead": {
                    this.incrementChunk((RecordedEvent)var0, var0.getInt("bytes"), this.readChunks);
                    break;
                }
                case "minecraft.ChunkRegionWrite": {
                    this.incrementChunk((RecordedEvent)var0, var0.getInt("bytes"), this.writtenChunks);
                    break;
                }
                case "jdk.ThreadAllocationStatistics": {
                    this.threadAllocationStats.add(ThreadAllocationStat.from(var0));
                    break;
                }
                case "jdk.GCHeapSummary": {
                    this.gcHeapStats.add(GcHeapStat.from(var0));
                    break;
                }
                case "jdk.CPULoad": {
                    this.cpuLoadStat.add(CpuLoadStat.from(var0));
                    break;
                }
                case "jdk.FileWrite": {
                    this.appendFileIO((RecordedEvent)var0, this.fileWrites, "bytesWritten");
                    break;
                }
                case "jdk.FileRead": {
                    this.appendFileIO((RecordedEvent)var0, this.fileReads, "bytesRead");
                    break;
                }
                case "jdk.GarbageCollection": {
                    ++this.garbageCollections;
                    this.gcTotalDuration = this.gcTotalDuration.plus(var0.getDuration());
                    break;
                }
            }
        });
    }

    private void incrementPacket(RecordedEvent var02, int var1, Map<PacketIdentification, MutableCountAndSize> var2) {
        var2.computeIfAbsent(PacketIdentification.from(var02), var0 -> new MutableCountAndSize()).increment(var1);
    }

    private void incrementChunk(RecordedEvent var02, int var1, Map<ChunkIdentification, MutableCountAndSize> var2) {
        var2.computeIfAbsent(ChunkIdentification.from(var02), var0 -> new MutableCountAndSize()).increment(var1);
    }

    private void appendFileIO(RecordedEvent var0, List<FileIOStat> var1, String var2) {
        var1.add(new FileIOStat(var0.getDuration(), var0.getString("path"), var0.getLong(var2)));
    }

    private static <T> IoSummary<T> collectIoStats(Duration var02, Map<T, MutableCountAndSize> var1) {
        List var2 = var1.entrySet().stream().map(var0 -> Pair.of(var0.getKey(), (Object)((MutableCountAndSize)var0.getValue()).toCountAndSize())).toList();
        return new IoSummary(var02, var2);
    }

    public static final class MutableCountAndSize {
        private long count;
        private long totalSize;

        public void increment(int var0) {
            this.totalSize += (long)var0;
            ++this.count;
        }

        public IoSummary.CountAndSize toCountAndSize() {
            return new IoSummary.CountAndSize(this.count, this.totalSize);
        }
    }
}

