/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics.profiling;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import net.minecraft.util.profiling.ActiveProfiler;
import net.minecraft.util.profiling.ContinuousProfiler;
import net.minecraft.util.profiling.EmptyProfileResults;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfileCollector;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsSamplerProvider;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.profiling.metrics.storage.RecordedDeviation;
import org.jspecify.annotations.Nullable;

public class ActiveMetricsRecorder
implements MetricsRecorder {
    public static final int PROFILING_MAX_DURATION_SECONDS = 10;
    private static @Nullable Consumer<Path> globalOnReportFinished = null;
    private final Map<MetricSampler, List<RecordedDeviation>> deviationsBySampler = new Object2ObjectOpenHashMap();
    private final ContinuousProfiler taskProfiler;
    private final Executor ioExecutor;
    private final MetricsPersister metricsPersister;
    private final Consumer<ProfileResults> onProfilingEnd;
    private final Consumer<Path> onReportFinished;
    private final MetricsSamplerProvider metricsSamplerProvider;
    private final LongSupplier wallTimeSource;
    private final long deadlineNano;
    private int currentTick;
    private ProfileCollector singleTickProfiler;
    private volatile boolean killSwitch;
    private Set<MetricSampler> thisTickSamplers = ImmutableSet.of();

    private ActiveMetricsRecorder(MetricsSamplerProvider var0, LongSupplier var1, Executor var2, MetricsPersister var3, Consumer<ProfileResults> var4, Consumer<Path> var5) {
        this.metricsSamplerProvider = var0;
        this.wallTimeSource = var1;
        this.taskProfiler = new ContinuousProfiler(var1, () -> this.currentTick, () -> false);
        this.ioExecutor = var2;
        this.metricsPersister = var3;
        this.onProfilingEnd = var4;
        this.onReportFinished = globalOnReportFinished == null ? var5 : var5.andThen(globalOnReportFinished);
        this.deadlineNano = var1.getAsLong() + TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
        this.singleTickProfiler = new ActiveProfiler(this.wallTimeSource, () -> this.currentTick, () -> true);
        this.taskProfiler.enable();
    }

    public static ActiveMetricsRecorder createStarted(MetricsSamplerProvider var0, LongSupplier var1, Executor var2, MetricsPersister var3, Consumer<ProfileResults> var4, Consumer<Path> var5) {
        return new ActiveMetricsRecorder(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public synchronized void end() {
        if (!this.isRecording()) {
            return;
        }
        this.killSwitch = true;
    }

    @Override
    public synchronized void cancel() {
        if (!this.isRecording()) {
            return;
        }
        this.singleTickProfiler = InactiveProfiler.INSTANCE;
        this.onProfilingEnd.accept(EmptyProfileResults.EMPTY);
        this.cleanup(this.thisTickSamplers);
    }

    @Override
    public void startTick() {
        this.verifyStarted();
        this.thisTickSamplers = this.metricsSamplerProvider.samplers(() -> this.singleTickProfiler);
        for (MetricSampler var1 : this.thisTickSamplers) {
            var1.onStartTick();
        }
        ++this.currentTick;
    }

    @Override
    public void endTick() {
        this.verifyStarted();
        if (this.currentTick == 0) {
            return;
        }
        for (MetricSampler var1 : this.thisTickSamplers) {
            var1.onEndTick(this.currentTick);
            if (!var1.triggersThreshold()) continue;
            RecordedDeviation var2 = new RecordedDeviation(Instant.now(), this.currentTick, this.singleTickProfiler.getResults());
            this.deviationsBySampler.computeIfAbsent(var1, var0 -> Lists.newArrayList()).add(var2);
        }
        if (this.killSwitch || this.wallTimeSource.getAsLong() > this.deadlineNano) {
            this.killSwitch = false;
            ProfileResults var02 = this.taskProfiler.getResults();
            this.singleTickProfiler = InactiveProfiler.INSTANCE;
            this.onProfilingEnd.accept(var02);
            this.scheduleSaveResults(var02);
            return;
        }
        this.singleTickProfiler = new ActiveProfiler(this.wallTimeSource, () -> this.currentTick, () -> true);
    }

    @Override
    public boolean isRecording() {
        return this.taskProfiler.isEnabled();
    }

    @Override
    public ProfilerFiller getProfiler() {
        return ProfilerFiller.combine(this.taskProfiler.getFiller(), this.singleTickProfiler);
    }

    private void verifyStarted() {
        if (!this.isRecording()) {
            throw new IllegalStateException("Not started!");
        }
    }

    private void scheduleSaveResults(ProfileResults var0) {
        HashSet<MetricSampler> var1 = new HashSet<MetricSampler>(this.thisTickSamplers);
        this.ioExecutor.execute(() -> {
            Path var2 = this.metricsPersister.saveReports(var1, this.deviationsBySampler, var0);
            this.cleanup(var1);
            this.onReportFinished.accept(var2);
        });
    }

    private void cleanup(Collection<MetricSampler> var0) {
        for (MetricSampler var2 : var0) {
            var2.onFinished();
        }
        this.deviationsBySampler.clear();
        this.taskProfiler.disable();
    }

    public static void registerGlobalCompletionCallback(Consumer<Path> var0) {
        globalOnReportFinished = var0;
    }
}

