/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class UniformInt
extends IntProvider {
    public static final MapCodec<UniformInt> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.INT.fieldOf("min_inclusive").forGetter(var0 -> var0.minInclusive), (App)Codec.INT.fieldOf("max_inclusive").forGetter(var0 -> var0.maxInclusive)).apply((Applicative)var02, UniformInt::new)).validate(var0 -> {
        if (var0.maxInclusive < var0.minInclusive) {
            return DataResult.error(() -> "Max must be at least min, min_inclusive: " + var0.minInclusive + ", max_inclusive: " + var0.maxInclusive);
        }
        return DataResult.success((Object)var0);
    });
    private final int minInclusive;
    private final int maxInclusive;

    private UniformInt(int var0, int var1) {
        this.minInclusive = var0;
        this.maxInclusive = var1;
    }

    public static UniformInt of(int var0, int var1) {
        return new UniformInt(var0, var1);
    }

    @Override
    public int sample(RandomSource var0) {
        return Mth.randomBetweenInclusive(var0, this.minInclusive, this.maxInclusive);
    }

    @Override
    public int getMinValue() {
        return this.minInclusive;
    }

    @Override
    public int getMaxValue() {
        return this.maxInclusive;
    }

    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.UNIFORM;
    }

    public String toString() {
        return "[" + this.minInclusive + "-" + this.maxInclusive + "]";
    }
}

