/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class RandomSequences
extends SavedData {
    public static final Codec<RandomSequences> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.INT.fieldOf("salt").forGetter(RandomSequences::salt), (App)Codec.BOOL.optionalFieldOf("include_world_seed", (Object)true).forGetter(RandomSequences::includeWorldSeed), (App)Codec.BOOL.optionalFieldOf("include_sequence_id", (Object)true).forGetter(RandomSequences::includeSequenceId), (App)Codec.unboundedMap(Identifier.CODEC, RandomSequence.CODEC).fieldOf("sequences").forGetter(var0 -> var0.sequences)).apply((Applicative)var02, RandomSequences::new));
    public static final SavedDataType<RandomSequences> TYPE = new SavedDataType<RandomSequences>("random_sequences", RandomSequences::new, CODEC, DataFixTypes.SAVED_DATA_RANDOM_SEQUENCES);
    private int salt;
    private boolean includeWorldSeed = true;
    private boolean includeSequenceId = true;
    private final Map<Identifier, RandomSequence> sequences = new Object2ObjectOpenHashMap();

    public RandomSequences() {
    }

    private RandomSequences(int var0, boolean var1, boolean var2, Map<Identifier, RandomSequence> var3) {
        this.salt = var0;
        this.includeWorldSeed = var1;
        this.includeSequenceId = var2;
        this.sequences.putAll(var3);
    }

    public RandomSource get(Identifier var0, long var1) {
        RandomSource var3 = this.sequences.computeIfAbsent(var0, var2 -> this.createSequence((Identifier)var2, var1)).random();
        return new DirtyMarkingRandomSource(var3);
    }

    private RandomSequence createSequence(Identifier var0, long var1) {
        return this.createSequence(var0, var1, this.salt, this.includeWorldSeed, this.includeSequenceId);
    }

    private RandomSequence createSequence(Identifier var0, long var1, int var3, boolean var4, boolean var5) {
        long var6 = (var4 ? var1 : 0L) ^ (long)var3;
        return new RandomSequence(var6, var5 ? Optional.of(var0) : Optional.empty());
    }

    public void forAllSequences(BiConsumer<Identifier, RandomSequence> var0) {
        this.sequences.forEach(var0);
    }

    public void setSeedDefaults(int var0, boolean var1, boolean var2) {
        this.salt = var0;
        this.includeWorldSeed = var1;
        this.includeSequenceId = var2;
    }

    public int clear() {
        int var0 = this.sequences.size();
        this.sequences.clear();
        return var0;
    }

    public void reset(Identifier var0, long var1) {
        this.sequences.put(var0, this.createSequence(var0, var1));
    }

    public void reset(Identifier var0, long var1, int var3, boolean var4, boolean var5) {
        this.sequences.put(var0, this.createSequence(var0, var1, var3, var4, var5));
    }

    private int salt() {
        return this.salt;
    }

    private boolean includeWorldSeed() {
        return this.includeWorldSeed;
    }

    private boolean includeSequenceId() {
        return this.includeSequenceId;
    }

    class DirtyMarkingRandomSource
    implements RandomSource {
        private final RandomSource random;

        DirtyMarkingRandomSource(RandomSource var1) {
            this.random = var1;
        }

        @Override
        public RandomSource fork() {
            RandomSequences.this.setDirty();
            return this.random.fork();
        }

        @Override
        public PositionalRandomFactory forkPositional() {
            RandomSequences.this.setDirty();
            return this.random.forkPositional();
        }

        @Override
        public void setSeed(long var0) {
            RandomSequences.this.setDirty();
            this.random.setSeed(var0);
        }

        @Override
        public int nextInt() {
            RandomSequences.this.setDirty();
            return this.random.nextInt();
        }

        @Override
        public int nextInt(int var0) {
            RandomSequences.this.setDirty();
            return this.random.nextInt(var0);
        }

        @Override
        public long nextLong() {
            RandomSequences.this.setDirty();
            return this.random.nextLong();
        }

        @Override
        public boolean nextBoolean() {
            RandomSequences.this.setDirty();
            return this.random.nextBoolean();
        }

        @Override
        public float nextFloat() {
            RandomSequences.this.setDirty();
            return this.random.nextFloat();
        }

        @Override
        public double nextDouble() {
            RandomSequences.this.setDirty();
            return this.random.nextDouble();
        }

        @Override
        public double nextGaussian() {
            RandomSequences.this.setDirty();
            return this.random.nextGaussian();
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 instanceof DirtyMarkingRandomSource) {
                DirtyMarkingRandomSource var1 = (DirtyMarkingRandomSource)var0;
                return this.random.equals(var1.random);
            }
            return false;
        }
    }
}

