/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public interface RandomizableContainer
extends Container {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";

    public @Nullable ResourceKey<LootTable> getLootTable();

    public void setLootTable(@Nullable ResourceKey<LootTable> var1);

    default public void setLootTable(ResourceKey<LootTable> var0, long var1) {
        this.setLootTable(var0);
        this.setLootTableSeed(var1);
    }

    public long getLootTableSeed();

    public void setLootTableSeed(long var1);

    public BlockPos getBlockPos();

    public @Nullable Level getLevel();

    public static void setBlockEntityLootTable(BlockGetter var0, RandomSource var1, BlockPos var2, ResourceKey<LootTable> var3) {
        BlockEntity var4 = var0.getBlockEntity(var2);
        if (var4 instanceof RandomizableContainer) {
            RandomizableContainer var5 = (RandomizableContainer)((Object)var4);
            var5.setLootTable(var3, var1.nextLong());
        }
    }

    default public boolean tryLoadLootTable(ValueInput var0) {
        ResourceKey var1 = var0.read(LOOT_TABLE_TAG, LootTable.KEY_CODEC).orElse(null);
        this.setLootTable(var1);
        this.setLootTableSeed(var0.getLongOr(LOOT_TABLE_SEED_TAG, 0L));
        return var1 != null;
    }

    default public boolean trySaveLootTable(ValueOutput var0) {
        ResourceKey<LootTable> var1 = this.getLootTable();
        if (var1 == null) {
            return false;
        }
        var0.store(LOOT_TABLE_TAG, LootTable.KEY_CODEC, var1);
        long var2 = this.getLootTableSeed();
        if (var2 != 0L) {
            var0.putLong(LOOT_TABLE_SEED_TAG, var2);
        }
        return true;
    }

    default public void unpackLootTable(@Nullable Player var0) {
        Level var1 = this.getLevel();
        BlockPos var2 = this.getBlockPos();
        ResourceKey<LootTable> var3 = this.getLootTable();
        if (var3 != null && var1 != null && var1.getServer() != null) {
            LootTable var4 = var1.getServer().reloadableRegistries().getLootTable(var3);
            if (var0 instanceof ServerPlayer) {
                CriteriaTriggers.GENERATE_LOOT.trigger((ServerPlayer)var0, var3);
            }
            this.setLootTable(null);
            LootParams.Builder var5 = new LootParams.Builder((ServerLevel)var1).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(var2));
            if (var0 != null) {
                var5.withLuck(var0.getLuck()).withParameter(LootContextParams.THIS_ENTITY, var0);
            }
            var4.fill(this, var5.create(LootContextParamSets.CHEST), this.getLootTableSeed());
        }
    }
}

