/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.mojang.serialization.DataResult;
import net.minecraft.util.Mth;

public interface AttributeRange<Value> {
    public static final AttributeRange<Float> UNIT_FLOAT = AttributeRange.ofFloat(0.0f, 1.0f);
    public static final AttributeRange<Float> NON_NEGATIVE_FLOAT = AttributeRange.ofFloat(0.0f, Float.POSITIVE_INFINITY);

    public static <Value> AttributeRange<Value> any() {
        return new AttributeRange<Value>(){

            @Override
            public DataResult<Value> validate(Value var0) {
                return DataResult.success(var0);
            }

            @Override
            public Value sanitize(Value var0) {
                return var0;
            }
        };
    }

    public static AttributeRange<Float> ofFloat(final float var0, final float var1) {
        return new AttributeRange<Float>(){

            @Override
            public DataResult<Float> validate(Float var02) {
                if (var02.floatValue() >= var0 && var02.floatValue() <= var1) {
                    return DataResult.success((Object)var02);
                }
                return DataResult.error(() -> var02 + " is not in range [" + var0 + "; " + var1 + "]");
            }

            @Override
            public Float sanitize(Float var02) {
                if (var02.floatValue() >= var0 && var02.floatValue() <= var1) {
                    return var02;
                }
                return Float.valueOf(Mth.clamp(var02.floatValue(), var0, var1));
            }
        };
    }

    public DataResult<Value> validate(Value var1);

    public Value sanitize(Value var1);
}

