/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.jspecify.annotations.Nullable;

public class DamageSource {
    private final Holder<DamageType> type;
    private final @Nullable Entity causingEntity;
    private final @Nullable Entity directEntity;
    private final @Nullable Vec3 damageSourcePosition;
    private @Nullable Block directBlock;
    private @Nullable BlockState directBlockState;
    private boolean sweep = false;
    private boolean melting = false;
    private boolean poison = false;
    private Entity customEntityDamager = null;
    private Entity customCausingEntityDamager = null;

    public DamageSource sweep() {
        this.sweep = true;
        return this;
    }

    public boolean isSweep() {
        return this.sweep;
    }

    public DamageSource melting() {
        this.melting = true;
        return this;
    }

    public boolean isMelting() {
        return this.melting;
    }

    public DamageSource poison() {
        this.poison = true;
        return this;
    }

    public boolean isPoison() {
        return this.poison;
    }

    public Entity getDamager() {
        return this.customEntityDamager != null ? this.customEntityDamager : this.directEntity;
    }

    public Entity getCausingDamager() {
        return this.customCausingEntityDamager != null ? this.customCausingEntityDamager : this.causingEntity;
    }

    public DamageSource customEntityDamager(Entity entity) {
        if (this.customEntityDamager != null || this.directEntity == entity || this.causingEntity == entity) {
            return this;
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.customEntityDamager = entity;
        return damageSource;
    }

    public DamageSource customCausingEntityDamager(Entity entity) {
        if (this.customCausingEntityDamager != null || this.directEntity == entity || this.causingEntity == entity) {
            return this;
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.customCausingEntityDamager = entity;
        return damageSource;
    }

    public Block getDirectBlock() {
        return this.directBlock;
    }

    public DamageSource directBlock(Level world, BlockPos blockPosition) {
        if (blockPosition == null || world == null) {
            return this;
        }
        return this.directBlock(CraftBlock.at(world, blockPosition));
    }

    public DamageSource directBlock(Block block) {
        if (block == null) {
            return this;
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.directBlock = block;
        return damageSource;
    }

    public BlockState getDirectBlockState() {
        return this.directBlockState;
    }

    public DamageSource directBlockState(BlockState blockState) {
        if (blockState == null) {
            return this;
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.directBlockState = blockState;
        return damageSource;
    }

    private DamageSource cloneInstance() {
        DamageSource damageSource = new DamageSource(this.type, this.directEntity, this.causingEntity, this.damageSourcePosition);
        damageSource.directBlock = this.getDirectBlock();
        damageSource.directBlockState = this.getDirectBlockState();
        damageSource.sweep = this.isSweep();
        damageSource.poison = this.isPoison();
        damageSource.melting = this.isMelting();
        return damageSource;
    }

    public String toString() {
        return "DamageSource (" + this.type().msgId() + ")";
    }

    public float getFoodExhaustion() {
        return this.type().exhaustion();
    }

    public boolean isDirect() {
        return this.causingEntity == this.directEntity;
    }

    public DamageSource(Holder<DamageType> holder, @Nullable Entity entity, @Nullable Entity entity1, @Nullable Vec3 vec3d) {
        this.type = holder;
        this.causingEntity = entity1;
        this.directEntity = entity;
        this.damageSourcePosition = vec3d;
    }

    public DamageSource(Holder<DamageType> holder, @Nullable Entity entity, @Nullable Entity entity1) {
        this(holder, entity, entity1, null);
    }

    public DamageSource(Holder<DamageType> holder, Vec3 vec3d) {
        this(holder, null, null, vec3d);
    }

    public DamageSource(Holder<DamageType> holder, @Nullable Entity entity) {
        this(holder, entity, entity);
    }

    public DamageSource(Holder<DamageType> holder) {
        this(holder, null, null, null);
    }

    public @Nullable Entity getDirectEntity() {
        return this.directEntity;
    }

    public @Nullable Entity getEntity() {
        return this.causingEntity;
    }

    public @Nullable ItemStack getWeaponItem() {
        return this.directEntity != null ? this.directEntity.getWeaponItem() : null;
    }

    public Component getLocalizedDeathMessage(LivingEntity entityliving) {
        ItemStack itemstack;
        String s = "death.attack." + this.type().msgId();
        if (this.causingEntity == null && this.directEntity == null) {
            LivingEntity entityliving1 = entityliving.getKillCredit();
            String s1 = s + ".player";
            return entityliving1 != null ? Component.translatable(s1, entityliving.getDisplayName(), entityliving1.getDisplayName()) : Component.translatable(s, entityliving.getDisplayName());
        }
        Component ichatbasecomponent = this.causingEntity == null ? this.directEntity.getDisplayName() : this.causingEntity.getDisplayName();
        Entity entity = this.causingEntity;
        if (entity instanceof LivingEntity) {
            LivingEntity entityliving2 = (LivingEntity)entity;
            itemstack = entityliving2.getMainHandItem();
        } else {
            itemstack = ItemStack.EMPTY;
        }
        ItemStack itemstack1 = itemstack;
        return !itemstack1.isEmpty() && itemstack1.has(DataComponents.CUSTOM_NAME) ? Component.translatable(s + ".item", entityliving.getDisplayName(), ichatbasecomponent, itemstack1.getDisplayName()) : Component.translatable(s, entityliving.getDisplayName(), ichatbasecomponent);
    }

    public String getMsgId() {
        return this.type().msgId();
    }

    public boolean scalesWithDifficulty() {
        return switch (this.type().scaling()) {
            case DamageScaling.NEVER -> false;
            case DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> this.causingEntity instanceof LivingEntity && !(this.causingEntity instanceof Player);
            case DamageScaling.ALWAYS -> true;
            default -> throw new MatchException(null, null);
        };
    }

    public boolean isCreativePlayer() {
        Entity entity = this.getEntity();
        if (entity instanceof Player) {
            Player entityhuman = (Player)entity;
            if (entityhuman.getAbilities().instabuild) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public @Nullable Vec3 getSourcePosition() {
        return this.damageSourcePosition != null ? this.damageSourcePosition : (this.directEntity != null ? this.directEntity.position() : null);
    }

    public @Nullable Vec3 sourcePositionRaw() {
        return this.damageSourcePosition;
    }

    public boolean is(TagKey<DamageType> tagkey) {
        return this.type.is(tagkey);
    }

    public boolean is(ResourceKey<DamageType> resourcekey) {
        return this.type.is(resourcekey);
    }

    public DamageType type() {
        return this.type.value();
    }

    public Holder<DamageType> typeHolder() {
        return this.type;
    }
}

