/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public record FallLocation(String id) {
    public static final FallLocation GENERIC = new FallLocation("generic");
    public static final FallLocation LADDER = new FallLocation("ladder");
    public static final FallLocation VINES = new FallLocation("vines");
    public static final FallLocation WEEPING_VINES = new FallLocation("weeping_vines");
    public static final FallLocation TWISTING_VINES = new FallLocation("twisting_vines");
    public static final FallLocation SCAFFOLDING = new FallLocation("scaffolding");
    public static final FallLocation OTHER_CLIMBABLE = new FallLocation("other_climbable");
    public static final FallLocation WATER = new FallLocation("water");

    public static FallLocation blockToFallLocation(BlockState var0) {
        if (var0.is(Blocks.LADDER) || var0.is(BlockTags.TRAPDOORS)) {
            return LADDER;
        }
        if (var0.is(Blocks.VINE)) {
            return VINES;
        }
        if (var0.is(Blocks.WEEPING_VINES) || var0.is(Blocks.WEEPING_VINES_PLANT)) {
            return WEEPING_VINES;
        }
        if (var0.is(Blocks.TWISTING_VINES) || var0.is(Blocks.TWISTING_VINES_PLANT)) {
            return TWISTING_VINES;
        }
        if (var0.is(Blocks.SCAFFOLDING)) {
            return SCAFFOLDING;
        }
        return OTHER_CLIMBABLE;
    }

    public static @Nullable FallLocation getCurrentFallLocation(LivingEntity var0) {
        Optional<BlockPos> var1 = var0.getLastClimbablePos();
        if (var1.isPresent()) {
            BlockState var2 = var0.level().getBlockState(var1.get());
            return FallLocation.blockToFallLocation(var2);
        }
        if (var0.isInWater()) {
            return WATER;
        }
        return null;
    }

    public String languageKey() {
        return "death.fell.accident." + this.id;
    }
}

