/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.jspecify.annotations.Nullable;

class HealOrHarmMobEffect
extends InstantenousMobEffect {
    private final boolean isHarm;

    public HealOrHarmMobEffect(MobEffectCategory mobeffectinfo, int i, boolean flag) {
        super(mobeffectinfo, i);
        this.isHarm = flag;
    }

    @Override
    public boolean applyEffectTick(ServerLevel worldserver, LivingEntity entityliving, int i) {
        if (this.isHarm == entityliving.isInvertedHealAndHarm()) {
            entityliving.heal(Math.max(4 << i, 0), EntityRegainHealthEvent.RegainReason.MAGIC);
        } else {
            entityliving.hurtServer(worldserver, entityliving.damageSources().magic(), 6 << i);
        }
        return true;
    }

    @Override
    public void applyInstantenousEffect(ServerLevel worldserver, @Nullable Entity entity, @Nullable Entity entity1, LivingEntity entityliving, int i, double d0) {
        if (this.isHarm == entityliving.isInvertedHealAndHarm()) {
            int j = (int)(d0 * (double)(4 << i) + 0.5);
            entityliving.heal(j, EntityRegainHealthEvent.RegainReason.MAGIC);
        } else {
            int k = (int)(d0 * (double)(6 << i) + 0.5);
            if (entity == null) {
                entityliving.hurtServer(worldserver, entityliving.damageSources().magic(), k);
            } else {
                entityliving.hurtServer(worldserver, entityliving.damageSources().indirectMagic(entity, entity1), k);
            }
        }
    }
}

