/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import org.jspecify.annotations.Nullable;

public class MobEffect
implements FeatureElement {
    public static final Codec<Holder<MobEffect>> CODEC = BuiltInRegistries.MOB_EFFECT.holderByNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<MobEffect>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.MOB_EFFECT);
    private static final int AMBIENT_ALPHA = Mth.floor(38.25f);
    private final Map<Holder<Attribute>, AttributeTemplate> attributeModifiers = new Object2ObjectOpenHashMap();
    private final MobEffectCategory category;
    private final int color;
    private final Function<MobEffectInstance, ParticleOptions> particleFactory;
    private @Nullable String descriptionId;
    private int blendInDurationTicks;
    private int blendOutDurationTicks;
    private int blendOutAdvanceTicks;
    private Optional<SoundEvent> soundOnAdded = Optional.empty();
    private FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;

    protected MobEffect(MobEffectCategory var0, int var12) {
        this.category = var0;
        this.color = var12;
        this.particleFactory = var1 -> {
            int var2 = var1.isAmbient() ? AMBIENT_ALPHA : 255;
            return ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, ARGB.color(var2, var12));
        };
    }

    protected MobEffect(MobEffectCategory var0, int var12, ParticleOptions var2) {
        this.category = var0;
        this.color = var12;
        this.particleFactory = var1 -> var2;
    }

    public int getBlendInDurationTicks() {
        return this.blendInDurationTicks;
    }

    public int getBlendOutDurationTicks() {
        return this.blendOutDurationTicks;
    }

    public int getBlendOutAdvanceTicks() {
        return this.blendOutAdvanceTicks;
    }

    public boolean applyEffectTick(ServerLevel var0, LivingEntity var1, int var2) {
        return true;
    }

    public void applyInstantenousEffect(ServerLevel var0, @Nullable Entity var1, @Nullable Entity var2, LivingEntity var3, int var4, double var5) {
        this.applyEffectTick(var0, var3, var4);
    }

    public boolean shouldApplyEffectTickThisTick(int var0, int var1) {
        return false;
    }

    public void onEffectStarted(LivingEntity var0, int var1) {
    }

    public void onEffectAdded(LivingEntity var0, int var12) {
        this.soundOnAdded.ifPresent(var1 -> var0.level().playSound(null, var0.getX(), var0.getY(), var0.getZ(), (SoundEvent)var1, var0.getSoundSource(), 1.0f, 1.0f));
    }

    public void onMobRemoved(ServerLevel var0, LivingEntity var1, int var2, Entity.RemovalReason var3) {
    }

    public void onMobHurt(ServerLevel var0, LivingEntity var1, int var2, DamageSource var3, float var4) {
    }

    public boolean isInstantenous() {
        return false;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId("effect", BuiltInRegistries.MOB_EFFECT.getKey(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public Component getDisplayName() {
        return Component.translatable(this.getDescriptionId());
    }

    public MobEffectCategory getCategory() {
        return this.category;
    }

    public int getColor() {
        return this.color;
    }

    public MobEffect addAttributeModifier(Holder<Attribute> var0, Identifier var1, double var2, AttributeModifier.Operation var4) {
        this.attributeModifiers.put(var0, new AttributeTemplate(var1, var2, var4));
        return this;
    }

    public MobEffect setBlendDuration(int var0) {
        return this.setBlendDuration(var0, var0, var0);
    }

    public MobEffect setBlendDuration(int var0, int var1, int var2) {
        this.blendInDurationTicks = var0;
        this.blendOutDurationTicks = var1;
        this.blendOutAdvanceTicks = var2;
        return this;
    }

    public void createModifiers(int var0, BiConsumer<Holder<Attribute>, AttributeModifier> var1) {
        this.attributeModifiers.forEach((var2, var3) -> var1.accept((Holder<Attribute>)var2, var3.create(var0)));
    }

    public void removeAttributeModifiers(AttributeMap var0) {
        for (Map.Entry<Holder<Attribute>, AttributeTemplate> var2 : this.attributeModifiers.entrySet()) {
            AttributeInstance var3 = var0.getInstance(var2.getKey());
            if (var3 == null) continue;
            var3.removeModifier(var2.getValue().id());
        }
    }

    public void addAttributeModifiers(AttributeMap var0, int var1) {
        for (Map.Entry<Holder<Attribute>, AttributeTemplate> var3 : this.attributeModifiers.entrySet()) {
            AttributeInstance var4 = var0.getInstance(var3.getKey());
            if (var4 == null) continue;
            var4.removeModifier(var3.getValue().id());
            var4.addPermanentModifier(var3.getValue().create(var1));
        }
    }

    public boolean isBeneficial() {
        return this.category == MobEffectCategory.BENEFICIAL;
    }

    public ParticleOptions createParticleOptions(MobEffectInstance var0) {
        return this.particleFactory.apply(var0);
    }

    public MobEffect withSoundOnAdded(SoundEvent var0) {
        this.soundOnAdded = Optional.of(var0);
        return this;
    }

    public MobEffect requiredFeatures(FeatureFlag ... var0) {
        this.requiredFeatures = FeatureFlags.REGISTRY.subset(var0);
        return this;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    record AttributeTemplate(Identifier id, double amount, AttributeModifier.Operation operation) {
        public AttributeModifier create(int var0) {
            return new AttributeModifier(this.id, this.amount * (double)(var0 + 1), this.operation);
        }
    }
}

