/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.function.Consumer;

public class AnimationState {
    private static final int STOPPED = Integer.MIN_VALUE;
    private int startTick = Integer.MIN_VALUE;

    public void start(int var0) {
        this.startTick = var0;
    }

    public void startIfStopped(int var0) {
        if (!this.isStarted()) {
            this.start(var0);
        }
    }

    public void animateWhen(boolean var0, int var1) {
        if (var0) {
            this.startIfStopped(var1);
        } else {
            this.stop();
        }
    }

    public void stop() {
        this.startTick = Integer.MIN_VALUE;
    }

    public void ifStarted(Consumer<AnimationState> var0) {
        if (this.isStarted()) {
            var0.accept(this);
        }
    }

    public void fastForward(int var0, float var1) {
        if (!this.isStarted()) {
            return;
        }
        this.startTick -= (int)((float)var0 * var1);
    }

    public long getTimeInMillis(float var0) {
        float var1 = var0 - (float)this.startTick;
        return (long)(var1 * 50.0f);
    }

    public boolean isStarted() {
        return this.startTick != Integer.MIN_VALUE;
    }

    public void copyFrom(AnimationState var0) {
        this.startTick = var0.startTick;
    }
}

