/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.world.item.ItemStack;

public class Crackiness {
    public static final Crackiness GOLEM = new Crackiness(0.75f, 0.5f, 0.25f);
    public static final Crackiness WOLF_ARMOR = new Crackiness(0.95f, 0.69f, 0.32f);
    private final float fractionLow;
    private final float fractionMedium;
    private final float fractionHigh;

    private Crackiness(float var0, float var1, float var2) {
        this.fractionLow = var0;
        this.fractionMedium = var1;
        this.fractionHigh = var2;
    }

    public Level byFraction(float var0) {
        if (var0 < this.fractionHigh) {
            return Level.HIGH;
        }
        if (var0 < this.fractionMedium) {
            return Level.MEDIUM;
        }
        if (var0 < this.fractionLow) {
            return Level.LOW;
        }
        return Level.NONE;
    }

    public Level byDamage(ItemStack var0) {
        if (!var0.isDamageableItem()) {
            return Level.NONE;
        }
        return this.byDamage(var0.getDamageValue(), var0.getMaxDamage());
    }

    public Level byDamage(int var0, int var1) {
        return this.byFraction((float)(var1 - var0) / (float)var1);
    }

    public static enum Level {
        NONE,
        LOW,
        MEDIUM,
        HIGH;

    }
}

