/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Util;
import net.minecraft.world.entity.EquipmentSlot;

public record DropChances(Map<EquipmentSlot, Float> byEquipment) {
    public static final float DEFAULT_EQUIPMENT_DROP_CHANCE = 0.085f;
    public static final float PRESERVE_ITEM_DROP_CHANCE_THRESHOLD = 1.0f;
    public static final int PRESERVE_ITEM_DROP_CHANCE = 2;
    public static final DropChances DEFAULT = new DropChances(Util.makeEnumMap(EquipmentSlot.class, var0 -> Float.valueOf(0.085f)));
    public static final Codec<DropChances> CODEC = Codec.unboundedMap(EquipmentSlot.CODEC, ExtraCodecs.NON_NEGATIVE_FLOAT).xmap(DropChances::toEnumMap, DropChances::filterDefaultValues).xmap(DropChances::new, DropChances::byEquipment);

    private static Map<EquipmentSlot, Float> filterDefaultValues(Map<EquipmentSlot, Float> var02) {
        HashMap<EquipmentSlot, Float> var1 = new HashMap<EquipmentSlot, Float>(var02);
        var1.values().removeIf(var0 -> var0.floatValue() == 0.085f);
        return var1;
    }

    private static Map<EquipmentSlot, Float> toEnumMap(Map<EquipmentSlot, Float> var0) {
        return Util.makeEnumMap(EquipmentSlot.class, var1 -> var0.getOrDefault(var1, Float.valueOf(0.085f)));
    }

    public DropChances withGuaranteedDrop(EquipmentSlot var0) {
        return this.withEquipmentChance(var0, 2.0f);
    }

    public DropChances withEquipmentChance(EquipmentSlot var0, float var1) {
        if (var1 < 0.0f) {
            throw new IllegalArgumentException("Tried to set invalid equipment chance " + var1 + " for " + String.valueOf(var0));
        }
        if (this.byEquipment(var0) == var1) {
            return this;
        }
        return new DropChances(Util.makeEnumMap(EquipmentSlot.class, var2 -> Float.valueOf(var2 == var0 ? var1 : this.byEquipment((EquipmentSlot)var2))));
    }

    public float byEquipment(EquipmentSlot var0) {
        return this.byEquipment.getOrDefault(var0, Float.valueOf(0.085f)).floatValue();
    }

    public boolean isPreserved(EquipmentSlot var0) {
        return this.byEquipment(var0) > 1.0f;
    }
}

