/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public final class EntitySelector {
    public static final Predicate<Entity> ENTITY_STILL_ALIVE = Entity::isAlive;
    public static final Predicate<Entity> LIVING_ENTITY_STILL_ALIVE = entity -> entity.isAlive() && entity instanceof LivingEntity;
    public static final Predicate<Entity> ENTITY_NOT_BEING_RIDDEN = entity -> entity.isAlive() && !entity.isVehicle() && !entity.isPassenger();
    public static final Predicate<Entity> CONTAINER_ENTITY_SELECTOR = entity -> entity instanceof Container && entity.isAlive();
    public static final Predicate<Entity> NO_CREATIVE_OR_SPECTATOR = entity -> {
        if (entity instanceof Player) {
            Player entityhuman = (Player)entity;
            if (entity.isSpectator() || entityhuman.isCreative()) {
                boolean flag = false;
                return flag;
            }
        }
        boolean flag = true;
        return flag;
    };
    public static final Predicate<Entity> NO_SPECTATORS = entity -> !entity.isSpectator();
    public static final Predicate<Entity> CAN_BE_COLLIDED_WITH = NO_SPECTATORS.and(entity -> entity.canBeCollidedWith(null));
    public static final Predicate<Entity> CAN_BE_PICKED = NO_SPECTATORS.and(Entity::isPickable);

    private EntitySelector() {
    }

    public static Predicate<Entity> withinDistance(double d0, double d1, double d2, double d3) {
        double d4 = d3 * d3;
        return entity -> entity.distanceToSqr(d0, d1, d2) <= d4;
    }

    public static Predicate<Entity> pushableBy(Entity entity) {
        PlayerTeam scoreboardteambase = entity.getTeam();
        Team.CollisionRule scoreboardteambase_enumteampush = scoreboardteambase == null ? Team.CollisionRule.ALWAYS : ((Team)scoreboardteambase).getCollisionRule();
        return scoreboardteambase_enumteampush == Team.CollisionRule.NEVER ? Predicates.alwaysFalse() : NO_SPECTATORS.and(entity1 -> {
            boolean flag;
            PlayerTeam scoreboardteambase1;
            Team.CollisionRule scoreboardteambase_enumteampush1;
            if (!entity1.canCollideWithBukkit(entity) || !entity.canCollideWithBukkit((Entity)entity1)) {
                return false;
            }
            if (entity.level().isClientSide()) {
                if (!(entity1 instanceof Player)) {
                    return false;
                }
                Player entityhuman = (Player)entity1;
                if (!entityhuman.isLocalPlayer()) {
                    return false;
                }
            }
            Team.CollisionRule collisionRule = scoreboardteambase_enumteampush1 = (scoreboardteambase1 = entity1.getTeam()) == null ? Team.CollisionRule.ALWAYS : ((Team)scoreboardteambase1).getCollisionRule();
            if (scoreboardteambase_enumteampush1 == Team.CollisionRule.NEVER) {
                return false;
            }
            boolean bl = flag = scoreboardteambase != null && scoreboardteambase.isAlliedTo(scoreboardteambase1);
            if ((scoreboardteambase_enumteampush == Team.CollisionRule.PUSH_OWN_TEAM || scoreboardteambase_enumteampush1 == Team.CollisionRule.PUSH_OWN_TEAM) && flag) {
                return false;
            }
            return scoreboardteambase_enumteampush != Team.CollisionRule.PUSH_OTHER_TEAMS && scoreboardteambase_enumteampush1 != Team.CollisionRule.PUSH_OTHER_TEAMS || flag;
        });
    }

    public static Predicate<Entity> notRiding(Entity entity) {
        return entity1 -> {
            while (entity1.isPassenger()) {
                if ((entity1 = entity1.getVehicle()) != entity) continue;
                return false;
            }
            return true;
        };
    }
}

