/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.util.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectType;

public interface InsideBlockEffectApplier {
    public static final InsideBlockEffectApplier NOOP = new InsideBlockEffectApplier(){

        @Override
        public void apply(InsideBlockEffectType var0) {
        }

        @Override
        public void runBefore(InsideBlockEffectType var0, Consumer<Entity> var1) {
        }

        @Override
        public void runAfter(InsideBlockEffectType var0, Consumer<Entity> var1) {
        }
    };

    public void apply(InsideBlockEffectType var1);

    public void runBefore(InsideBlockEffectType var1, Consumer<Entity> var2);

    public void runAfter(InsideBlockEffectType var1, Consumer<Entity> var2);

    public static class StepBasedCollector
    implements InsideBlockEffectApplier {
        private static final InsideBlockEffectType[] APPLY_ORDER = InsideBlockEffectType.values();
        private static final int NO_STEP = -1;
        private final Set<InsideBlockEffectType> effectsInStep = EnumSet.noneOf(InsideBlockEffectType.class);
        private final Map<InsideBlockEffectType, List<Consumer<Entity>>> beforeEffectsInStep = Util.makeEnumMap(InsideBlockEffectType.class, var0 -> new ArrayList());
        private final Map<InsideBlockEffectType, List<Consumer<Entity>>> afterEffectsInStep = Util.makeEnumMap(InsideBlockEffectType.class, var0 -> new ArrayList());
        private final List<Consumer<Entity>> finalEffects = new ArrayList<Consumer<Entity>>();
        private int lastStep = -1;

        public void advanceStep(int var0) {
            if (this.lastStep != var0) {
                this.lastStep = var0;
                this.flushStep();
            }
        }

        public void applyAndClear(Entity var0) {
            this.flushStep();
            for (Consumer<Entity> var2 : this.finalEffects) {
                if (!var0.isAlive()) break;
                var2.accept(var0);
            }
            this.finalEffects.clear();
            this.lastStep = -1;
        }

        private void flushStep() {
            for (InsideBlockEffectType var3 : APPLY_ORDER) {
                List<Consumer<Entity>> var4 = this.beforeEffectsInStep.get((Object)var3);
                this.finalEffects.addAll(var4);
                var4.clear();
                if (this.effectsInStep.remove((Object)var3)) {
                    this.finalEffects.add(var3.effect());
                }
                List<Consumer<Entity>> var5 = this.afterEffectsInStep.get((Object)var3);
                this.finalEffects.addAll(var5);
                var5.clear();
            }
        }

        @Override
        public void apply(InsideBlockEffectType var0) {
            this.effectsInStep.add(var0);
        }

        @Override
        public void runBefore(InsideBlockEffectType var0, Consumer<Entity> var1) {
            this.beforeEffectsInStep.get((Object)var0).add(var1);
        }

        @Override
        public void runAfter(InsideBlockEffectType var0, Consumer<Entity> var1) {
            this.afterEffectsInStep.get((Object)var0).add(var1);
        }
    }
}

