/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import org.jspecify.annotations.Nullable;

public class AttributeMap {
    private final Map<Holder<Attribute>, AttributeInstance> attributes = new Object2ObjectOpenHashMap();
    private final Set<AttributeInstance> attributesToSync = new ObjectOpenHashSet();
    private final Set<AttributeInstance> attributesToUpdate = new ObjectOpenHashSet();
    private final AttributeSupplier supplier;

    public AttributeMap(AttributeSupplier var0) {
        this.supplier = var0;
    }

    private void onAttributeModified(AttributeInstance var0) {
        this.attributesToUpdate.add(var0);
        if (var0.getAttribute().value().isClientSyncable()) {
            this.attributesToSync.add(var0);
        }
    }

    public Set<AttributeInstance> getAttributesToSync() {
        return this.attributesToSync;
    }

    public Set<AttributeInstance> getAttributesToUpdate() {
        return this.attributesToUpdate;
    }

    public Collection<AttributeInstance> getSyncableAttributes() {
        return this.attributes.values().stream().filter(var0 -> var0.getAttribute().value().isClientSyncable()).collect(Collectors.toList());
    }

    public @Nullable AttributeInstance getInstance(Holder<Attribute> var02) {
        return this.attributes.computeIfAbsent(var02, var0 -> this.supplier.createInstance(this::onAttributeModified, (Holder<Attribute>)var0));
    }

    public boolean hasAttribute(Holder<Attribute> var0) {
        return this.attributes.get(var0) != null || this.supplier.hasAttribute(var0);
    }

    public boolean hasModifier(Holder<Attribute> var0, Identifier var1) {
        AttributeInstance var2 = this.attributes.get(var0);
        return var2 != null ? var2.getModifier(var1) != null : this.supplier.hasModifier(var0, var1);
    }

    public double getValue(Holder<Attribute> var0) {
        AttributeInstance var1 = this.attributes.get(var0);
        return var1 != null ? var1.getValue() : this.supplier.getValue(var0);
    }

    public double getBaseValue(Holder<Attribute> var0) {
        AttributeInstance var1 = this.attributes.get(var0);
        return var1 != null ? var1.getBaseValue() : this.supplier.getBaseValue(var0);
    }

    public double getModifierValue(Holder<Attribute> var0, Identifier var1) {
        AttributeInstance var2 = this.attributes.get(var0);
        return var2 != null ? var2.getModifier(var1).amount() : this.supplier.getModifierValue(var0, var1);
    }

    public void addTransientAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> var02) {
        var02.forEach((var0, var1) -> {
            AttributeInstance var2 = this.getInstance((Holder<Attribute>)var0);
            if (var2 != null) {
                var2.removeModifier(var1.id());
                var2.addTransientModifier((AttributeModifier)var1);
            }
        });
    }

    public void removeAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> var02) {
        var02.asMap().forEach((var0, var12) -> {
            AttributeInstance var2 = this.attributes.get(var0);
            if (var2 != null) {
                var12.forEach(var1 -> var2.removeModifier(var1.id()));
            }
        });
    }

    public void assignAllValues(AttributeMap var02) {
        var02.attributes.values().forEach(var0 -> {
            AttributeInstance var1 = this.getInstance(var0.getAttribute());
            if (var1 != null) {
                var1.replaceFrom((AttributeInstance)var0);
            }
        });
    }

    public void assignBaseValues(AttributeMap var02) {
        var02.attributes.values().forEach(var0 -> {
            AttributeInstance var1 = this.getInstance(var0.getAttribute());
            if (var1 != null) {
                var1.setBaseValue(var0.getBaseValue());
            }
        });
    }

    public void assignPermanentModifiers(AttributeMap var02) {
        var02.attributes.values().forEach(var0 -> {
            AttributeInstance var1 = this.getInstance(var0.getAttribute());
            if (var1 != null) {
                var1.addPermanentModifiers(var0.getPermanentModifiers());
            }
        });
    }

    public boolean resetBaseValue(Holder<Attribute> var0) {
        if (!this.supplier.hasAttribute(var0)) {
            return false;
        }
        AttributeInstance var1 = this.attributes.get(var0);
        if (var1 != null) {
            var1.setBaseValue(this.supplier.getBaseValue(var0));
        }
        return true;
    }

    public List<AttributeInstance.Packed> pack() {
        ArrayList<AttributeInstance.Packed> var0 = new ArrayList<AttributeInstance.Packed>(this.attributes.values().size());
        for (AttributeInstance var2 : this.attributes.values()) {
            var0.add(var2.pack());
        }
        return var0;
    }

    public void apply(List<AttributeInstance.Packed> var0) {
        for (AttributeInstance.Packed var2 : var0) {
            AttributeInstance var3 = this.getInstance(var2.attribute());
            if (var3 == null) continue;
            var3.apply(var2);
        }
    }
}

