/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;

public class ChargeAttack
extends Behavior<Animal> {
    private final int timeBetweenAttacks;
    private final TargetingConditions chargeTargeting;
    private final float speed;
    private final float knockbackForce;
    private final double maxTargetDetectionDistance;
    private final double maxChargeDistance;
    private final SoundEvent chargeSound;
    private Vec3 chargeVelocityVector;
    private Vec3 startPosition;

    public ChargeAttack(int var0, TargetingConditions var1, float var2, float var3, double var4, double var6, SoundEvent var8) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.CHARGE_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.timeBetweenAttacks = var0;
        this.chargeTargeting = var1;
        this.speed = var2;
        this.knockbackForce = var3;
        this.maxChargeDistance = var4;
        this.maxTargetDetectionDistance = var6;
        this.chargeSound = var8;
        this.chargeVelocityVector = Vec3.ZERO;
        this.startPosition = Vec3.ZERO;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Animal var1) {
        return var1.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Animal var1, long var2) {
        TamableAnimal var7;
        Brain<Integer> var4 = var1.getBrain();
        Optional<LivingEntity> var5 = var4.getMemory(MemoryModuleType.ATTACK_TARGET);
        if (var5.isEmpty()) {
            return false;
        }
        LivingEntity var6 = var5.get();
        if (var1 instanceof TamableAnimal && (var7 = (TamableAnimal)var1).isTame()) {
            return false;
        }
        if (var1.position().subtract(this.startPosition).lengthSqr() >= this.maxChargeDistance * this.maxChargeDistance) {
            return false;
        }
        if (var6.position().subtract(var1.position()).lengthSqr() >= this.maxTargetDetectionDistance * this.maxTargetDetectionDistance) {
            return false;
        }
        if (!var1.hasLineOfSight(var6)) {
            return false;
        }
        return !var4.hasMemoryValue(MemoryModuleType.CHARGE_COOLDOWN_TICKS);
    }

    @Override
    protected void start(ServerLevel var0, Animal var1, long var2) {
        Brain<?> var4 = var1.getBrain();
        this.startPosition = var1.position();
        LivingEntity var5 = var4.getMemory(MemoryModuleType.ATTACK_TARGET).get();
        Vec3 var6 = var5.position().subtract(var1.position()).normalize();
        this.chargeVelocityVector = var6.scale(this.speed);
        if (this.canStillUse(var0, var1, var2)) {
            var1.playSound(this.chargeSound);
        }
    }

    @Override
    protected void tick(ServerLevel var0, Animal var1, long var22) {
        Brain<?> var4 = var1.getBrain();
        LivingEntity var5 = var4.getMemory(MemoryModuleType.ATTACK_TARGET).orElseThrow();
        var1.lookAt(var5, 360.0f, 360.0f);
        var1.setDeltaMovement(this.chargeVelocityVector);
        ArrayList var6 = new ArrayList(1);
        var0.getEntities(EntityTypeTest.forClass(LivingEntity.class), var1.getBoundingBox(), var2 -> this.chargeTargeting.test(var0, var1, (LivingEntity)var2), var6, 1);
        if (!var6.isEmpty()) {
            LivingEntity var7 = (LivingEntity)var6.get(0);
            if (var1.hasPassenger(var7)) {
                return;
            }
            this.dealDamageToTarget(var0, var1, var7);
            this.dealKnockBack(var1, var7);
            this.stop(var0, var1, var22);
        }
    }

    private void dealDamageToTarget(ServerLevel var0, Animal var1, LivingEntity var2) {
        float var4;
        DamageSource var3 = var0.damageSources().mobAttack(var1);
        if (var2.hurtServer(var0, var3, var4 = (float)var1.getAttributeValue(Attributes.ATTACK_DAMAGE))) {
            EnchantmentHelper.doPostAttackEffects(var0, var2, var3);
        }
    }

    private void dealKnockBack(Animal var0, LivingEntity var1) {
        int var2 = var0.hasEffect(MobEffects.SPEED) ? var0.getEffect(MobEffects.SPEED).getAmplifier() + 1 : 0;
        int var3 = var0.hasEffect(MobEffects.SLOWNESS) ? var0.getEffect(MobEffects.SLOWNESS).getAmplifier() + 1 : 0;
        float var4 = 0.25f * (float)(var2 - var3);
        float var5 = Mth.clamp(this.speed * (float)var0.getAttributeValue(Attributes.MOVEMENT_SPEED), 0.2f, 2.0f) + var4;
        var0.causeExtraKnockback(var1, var5 * this.knockbackForce, var0.getDeltaMovement());
    }

    @Override
    protected void stop(ServerLevel var0, Animal var1, long var2) {
        var1.getBrain().setMemory(MemoryModuleType.CHARGE_COOLDOWN_TICKS, this.timeBetweenAttacks);
        var1.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Animal)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Animal)livingEntity, l);
    }
}

