/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;

public class CrossbowAttack<E extends Mob, T extends LivingEntity>
extends Behavior<E> {
    private static final int TIMEOUT = 1200;
    private int attackDelay;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;

    public CrossbowAttack() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 1200);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, E var1) {
        LivingEntity var2 = CrossbowAttack.getAttackTarget(var1);
        return ((LivingEntity)var1).isHolding(Items.CROSSBOW) && BehaviorUtils.canSee(var1, var2) && BehaviorUtils.isWithinAttackRange(var1, var2, 0);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, E var1, long var2) {
        return ((LivingEntity)var1).getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && this.checkExtraStartConditions(var0, var1);
    }

    @Override
    protected void tick(ServerLevel var0, E var1, long var2) {
        LivingEntity var4 = CrossbowAttack.getAttackTarget(var1);
        this.lookAtTarget((Mob)var1, var4);
        this.crossbowAttack(var1, var4);
    }

    @Override
    protected void stop(ServerLevel var0, E var1, long var2) {
        if (((LivingEntity)var1).isUsingItem()) {
            ((LivingEntity)var1).stopUsingItem();
        }
        if (((LivingEntity)var1).isHolding(Items.CROSSBOW)) {
            ((CrossbowAttackMob)var1).setChargingCrossbow(false);
            ((LivingEntity)var1).getUseItem().set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        }
    }

    private void crossbowAttack(E var0, LivingEntity var1) {
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            ((LivingEntity)var0).startUsingItem(ProjectileUtil.getWeaponHoldingHand(var0, Items.CROSSBOW));
            this.crossbowState = CrossbowState.CHARGING;
            ((CrossbowAttackMob)var0).setChargingCrossbow(true);
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            ItemStack var3;
            int var2;
            if (!((LivingEntity)var0).isUsingItem()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((var2 = ((LivingEntity)var0).getTicksUsingItem()) >= CrossbowItem.getChargeDuration(var3 = ((LivingEntity)var0).getUseItem(), var0)) {
                ((LivingEntity)var0).releaseUsingItem();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = 20 + ((Entity)var0).getRandom().nextInt(20);
                ((CrossbowAttackMob)var0).setChargingCrossbow(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK) {
            ((RangedAttackMob)var0).performRangedAttack(var1, 1.0f);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private void lookAtTarget(Mob var0, LivingEntity var1) {
        var0.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(var1, true));
    }

    private static LivingEntity getAttackTarget(LivingEntity var0) {
        return var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (E)((Mob)livingEntity), l);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.tick(serverLevel, (E)((Mob)livingEntity), l);
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

