/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.allay.AllayAi;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GoAndGiveItemsToTarget<E extends LivingEntity>
extends Behavior<E> {
    private static final int CLOSE_ENOUGH_DISTANCE_TO_TARGET = 3;
    private static final int ITEM_PICKUP_COOLDOWN_AFTER_THROWING = 60;
    private final Function<LivingEntity, Optional<PositionTracker>> targetPositionGetter;
    private final float speedModifier;

    public GoAndGiveItemsToTarget(Function<LivingEntity, Optional<PositionTracker>> var0, float var1, int var2) {
        super(Map.of(MemoryModuleType.LOOK_TARGET, MemoryStatus.REGISTERED, MemoryModuleType.WALK_TARGET, MemoryStatus.REGISTERED, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, MemoryStatus.REGISTERED), var2);
        this.targetPositionGetter = var0;
        this.speedModifier = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, E var1) {
        return this.canThrowItemToTarget(var1);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, E var1, long var2) {
        return this.canThrowItemToTarget(var1);
    }

    @Override
    protected void start(ServerLevel var0, E var12, long var2) {
        this.targetPositionGetter.apply((LivingEntity)var12).ifPresent(var1 -> BehaviorUtils.setWalkAndLookTargetMemories(var12, var1, this.speedModifier, 3));
    }

    @Override
    protected void tick(ServerLevel var0, E var1, long var22) {
        ItemStack var8;
        Optional<PositionTracker> var4 = this.targetPositionGetter.apply((LivingEntity)var1);
        if (var4.isEmpty()) {
            return;
        }
        PositionTracker var5 = var4.get();
        double var6 = var5.currentPosition().distanceTo(((Entity)var1).getEyePosition());
        if (var6 < 3.0 && !(var8 = ((InventoryCarrier)var1).getInventory().removeItem(0, 1)).isEmpty()) {
            GoAndGiveItemsToTarget.throwItem(var1, var8, GoAndGiveItemsToTarget.getThrowPosition(var5));
            if (var1 instanceof Allay) {
                Allay var9 = (Allay)var1;
                AllayAi.getLikedPlayer(var9).ifPresent(var2 -> this.triggerDropItemOnBlock(var5, var8, (ServerPlayer)var2));
            }
            ((LivingEntity)var1).getBrain().setMemory(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, 60);
        }
    }

    private void triggerDropItemOnBlock(PositionTracker var0, ItemStack var1, ServerPlayer var2) {
        BlockPos var3 = var0.currentBlockPosition().below();
        CriteriaTriggers.ALLAY_DROP_ITEM_ON_BLOCK.trigger(var2, var3, var1);
    }

    private boolean canThrowItemToTarget(E var0) {
        if (((InventoryCarrier)var0).getInventory().isEmpty()) {
            return false;
        }
        Optional<PositionTracker> var1 = this.targetPositionGetter.apply((LivingEntity)var0);
        return var1.isPresent();
    }

    private static Vec3 getThrowPosition(PositionTracker var0) {
        return var0.currentPosition().add(0.0, 1.0, 0.0);
    }

    public static void throwItem(LivingEntity var0, ItemStack var1, Vec3 var2) {
        Vec3 var3 = new Vec3(0.2f, 0.3f, 0.2f);
        BehaviorUtils.throwItem(var0, var1, var2, var3, 0.2f);
        Level var4 = var0.level();
        if (var4.getGameTime() % 7L == 0L && var4.random.nextDouble() < 0.9) {
            float var5 = Util.getRandom(Allay.THROW_SOUND_PITCHES, var4.getRandom()).floatValue();
            var4.playSound(null, var0, SoundEvents.ALLAY_THROW, SoundSource.NEUTRAL, 1.0f, var5);
        }
    }
}

