/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityInteractEvent;
import org.jspecify.annotations.Nullable;

public class InteractWithDoor {
    private static final int COOLDOWN_BEFORE_RERUNNING_IN_SAME_NODE = 20;
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 3.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;

    public static BehaviorControl<LivingEntity> create() {
        MutableObject mutableobject = new MutableObject();
        MutableInt mutableint = new MutableInt(0);
        return BehaviorBuilder.create(behaviorbuilder_b -> behaviorbuilder_b.group(behaviorbuilder_b.present(MemoryModuleType.PATH), behaviorbuilder_b.registered(MemoryModuleType.DOORS_TO_CLOSE), behaviorbuilder_b.registered(MemoryModuleType.NEAREST_LIVING_ENTITIES)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1, memoryaccessor2) -> (worldserver, entityliving, i) -> {
            Path pathentity = (Path)behaviorbuilder_b.get(memoryaccessor);
            Optional<Set<GlobalPos>> optional = behaviorbuilder_b.tryGet(memoryaccessor1);
            if (!pathentity.notStarted() && !pathentity.isDone()) {
                DoorBlock blockdoor1;
                BlockPos blockposition1;
                BlockState iblockdata1;
                if (Objects.equals(mutableobject.get(), pathentity.getNextNode())) {
                    mutableint.setValue(20);
                } else if (mutableint.decrementAndGet() > 0) {
                    return false;
                }
                mutableobject.setValue((Object)pathentity.getNextNode());
                Node pathpoint = pathentity.getPreviousNode();
                Node pathpoint1 = pathentity.getNextNode();
                BlockPos blockposition = pathpoint.asBlockPos();
                BlockState iblockdata = worldserver.getBlockState(blockposition);
                if (iblockdata.is(BlockTags.MOB_INTERACTABLE_DOORS, blockbase_blockdata -> blockbase_blockdata.getBlock() instanceof DoorBlock)) {
                    DoorBlock blockdoor = (DoorBlock)iblockdata.getBlock();
                    if (!blockdoor.isOpen(iblockdata)) {
                        EntityInteractEvent event = new EntityInteractEvent((Entity)entityliving.getBukkitEntity(), (Block)CraftBlock.at(entityliving.level(), blockposition));
                        entityliving.level().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return false;
                        }
                        blockdoor.setOpen(entityliving, worldserver, iblockdata, blockposition, true);
                    }
                    optional = InteractWithDoor.rememberDoorToClose(memoryaccessor1, optional, worldserver, blockposition);
                }
                if ((iblockdata1 = worldserver.getBlockState(blockposition1 = pathpoint1.asBlockPos())).is(BlockTags.MOB_INTERACTABLE_DOORS, blockbase_blockdata -> blockbase_blockdata.getBlock() instanceof DoorBlock) && !(blockdoor1 = (DoorBlock)iblockdata1.getBlock()).isOpen(iblockdata1)) {
                    EntityInteractEvent event = new EntityInteractEvent((Entity)entityliving.getBukkitEntity(), (Block)CraftBlock.at(entityliving.level(), blockposition1));
                    entityliving.level().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return false;
                    }
                    blockdoor1.setOpen(entityliving, worldserver, iblockdata1, blockposition1, true);
                    optional = InteractWithDoor.rememberDoorToClose(memoryaccessor1, optional, worldserver, blockposition1);
                }
                optional.ifPresent(set -> InteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough(worldserver, entityliving, pathpoint, pathpoint1, set, behaviorbuilder_b.tryGet(memoryaccessor2)));
                return true;
            }
            return false;
        }));
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(ServerLevel worldserver, LivingEntity entityliving, @Nullable Node pathpoint, @Nullable Node pathpoint1, Set<GlobalPos> set, Optional<List<LivingEntity>> optional) {
        Iterator<GlobalPos> iterator = set.iterator();
        while (iterator.hasNext()) {
            GlobalPos globalpos = iterator.next();
            BlockPos blockposition = globalpos.pos();
            if (pathpoint != null && pathpoint.asBlockPos().equals(blockposition) || pathpoint1 != null && pathpoint1.asBlockPos().equals(blockposition)) continue;
            if (InteractWithDoor.isDoorTooFarAway(worldserver, entityliving, globalpos)) {
                iterator.remove();
                continue;
            }
            BlockState iblockdata = worldserver.getBlockState(blockposition);
            if (!iblockdata.is(BlockTags.MOB_INTERACTABLE_DOORS, blockbase_blockdata -> blockbase_blockdata.getBlock() instanceof DoorBlock)) {
                iterator.remove();
                continue;
            }
            DoorBlock blockdoor = (DoorBlock)iblockdata.getBlock();
            if (!blockdoor.isOpen(iblockdata)) {
                iterator.remove();
                continue;
            }
            if (InteractWithDoor.areOtherMobsComingThroughDoor(entityliving, blockposition, optional)) {
                iterator.remove();
                continue;
            }
            blockdoor.setOpen(entityliving, worldserver, iblockdata, blockposition, false);
            iterator.remove();
        }
    }

    private static boolean areOtherMobsComingThroughDoor(LivingEntity entityliving, BlockPos blockposition, Optional<List<LivingEntity>> optional) {
        return optional.isEmpty() ? false : optional.get().stream().filter(entityliving1 -> entityliving1.getType() == entityliving.getType()).filter(entityliving1 -> blockposition.closerToCenterThan(entityliving1.position(), 2.0)).anyMatch(entityliving1 -> InteractWithDoor.isMobComingThroughDoor(entityliving1.getBrain(), blockposition));
    }

    private static boolean isMobComingThroughDoor(Brain<?> behaviorcontroller, BlockPos blockposition) {
        if (!behaviorcontroller.hasMemoryValue(MemoryModuleType.PATH)) {
            return false;
        }
        Path pathentity = behaviorcontroller.getMemory(MemoryModuleType.PATH).get();
        if (pathentity.isDone()) {
            return false;
        }
        Node pathpoint = pathentity.getPreviousNode();
        if (pathpoint == null) {
            return false;
        }
        Node pathpoint1 = pathentity.getNextNode();
        return blockposition.equals(pathpoint.asBlockPos()) || blockposition.equals(pathpoint1.asBlockPos());
    }

    private static boolean isDoorTooFarAway(ServerLevel worldserver, LivingEntity entityliving, GlobalPos globalpos) {
        return globalpos.dimension() != worldserver.dimension() || !globalpos.pos().closerToCenterThan(entityliving.position(), 3.0);
    }

    private static Optional<Set<GlobalPos>> rememberDoorToClose(MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>> memoryaccessor, Optional<Set<GlobalPos>> optional, ServerLevel worldserver, BlockPos blockposition) {
        GlobalPos globalpos = GlobalPos.of(worldserver.dimension(), blockposition);
        return Optional.of(optional.map(set -> {
            set.add(globalpos);
            return set;
        }).orElseGet(() -> {
            HashSet set = Sets.newHashSet((Object[])new GlobalPos[]{globalpos});
            memoryaccessor.set(set);
            return set;
        }));
    }
}

