/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class RandomStroll {
    private static final int MAX_XZ_DIST = 10;
    private static final int MAX_Y_DIST = 7;
    private static final int[][] SWIM_XY_DISTANCE_TIERS = new int[][]{{1, 1}, {3, 3}, {5, 5}, {6, 5}, {7, 7}, {10, 7}};

    public static OneShot<PathfinderMob> stroll(float var0) {
        return RandomStroll.stroll(var0, true);
    }

    public static OneShot<PathfinderMob> stroll(float var02, boolean var1) {
        return RandomStroll.strollFlyOrSwim(var02, var0 -> LandRandomPos.getPos(var0, 10, 7), var1 ? var0 -> true : var0 -> !var0.isInWater());
    }

    public static BehaviorControl<PathfinderMob> stroll(float var02, int var1, int var22) {
        return RandomStroll.strollFlyOrSwim(var02, var2 -> LandRandomPos.getPos(var2, var1, var22), var0 -> true);
    }

    public static BehaviorControl<PathfinderMob> fly(float var02) {
        return RandomStroll.strollFlyOrSwim(var02, var0 -> RandomStroll.getTargetFlyPos(var0, 10, 7), var0 -> true);
    }

    public static BehaviorControl<PathfinderMob> swim(float var0) {
        return RandomStroll.strollFlyOrSwim(var0, RandomStroll::getTargetSwimPos, Entity::isInWater);
    }

    private static OneShot<PathfinderMob> strollFlyOrSwim(float var0, Function<PathfinderMob, Vec3> var1, Predicate<PathfinderMob> var2) {
        return BehaviorBuilder.create(var32 -> var32.group(var32.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)var32, var3 -> (var4, var5, var6) -> {
            if (!var2.test((PathfinderMob)var5)) {
                return false;
            }
            Optional<Vec3> var8 = Optional.ofNullable((Vec3)var1.apply((PathfinderMob)var5));
            var3.setOrErase(var8.map(var1 -> new WalkTarget((Vec3)var1, var0, 0)));
            return true;
        }));
    }

    private static @Nullable Vec3 getTargetSwimPos(PathfinderMob var0) {
        Vec3 var1 = null;
        Vec3 var2 = null;
        for (int[] var6 : SWIM_XY_DISTANCE_TIERS) {
            var2 = var1 == null ? BehaviorUtils.getRandomSwimmablePos(var0, var6[0], var6[1]) : var0.position().add(var0.position().vectorTo(var1).normalize().multiply(var6[0], var6[1], var6[0]));
            boolean var7 = GoalUtils.mobRestricted(var0, var6[0]);
            if (var2 == null || var0.level().getFluidState(BlockPos.containing(var2)).isEmpty() || GoalUtils.isRestricted(var7, var0, var2)) {
                return var1;
            }
            var1 = var2;
        }
        return var2;
    }

    private static @Nullable Vec3 getTargetFlyPos(PathfinderMob var0, int var1, int var2) {
        Vec3 var3 = var0.getViewVector(0.0f);
        return AirAndWaterRandomPos.getPos(var0, var1, var2, -2, var3.x, var3.z, 1.5707963705062866);
    }
}

