/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jspecify.annotations.Nullable;

public class ShowTradesToPlayer
extends Behavior<Villager> {
    private static final int MAX_LOOK_TIME = 900;
    private static final int STARTING_LOOK_TIME = 40;
    private @Nullable ItemStack playerItemStack;
    private final List<ItemStack> displayItems = Lists.newArrayList();
    private int cycleCounter;
    private int displayIndex;
    private int lookTime;

    public ShowTradesToPlayer(int var0, int var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.INTERACTION_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), var0, var1);
    }

    @Override
    public boolean checkExtraStartConditions(ServerLevel var0, Villager var1) {
        Brain<Villager> var2 = var1.getBrain();
        if (var2.getMemory(MemoryModuleType.INTERACTION_TARGET).isEmpty()) {
            return false;
        }
        LivingEntity var3 = var2.getMemory(MemoryModuleType.INTERACTION_TARGET).get();
        return var3.getType() == EntityType.PLAYER && var1.isAlive() && var3.isAlive() && !var1.isBaby() && var1.distanceToSqr(var3) <= 17.0;
    }

    @Override
    public boolean canStillUse(ServerLevel var0, Villager var1, long var2) {
        return this.checkExtraStartConditions(var0, var1) && this.lookTime > 0 && var1.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).isPresent();
    }

    @Override
    public void start(ServerLevel var0, Villager var1, long var2) {
        super.start(var0, var1, var2);
        this.lookAtTarget(var1);
        this.cycleCounter = 0;
        this.displayIndex = 0;
        this.lookTime = 40;
    }

    @Override
    public void tick(ServerLevel var0, Villager var1, long var2) {
        LivingEntity var4 = this.lookAtTarget(var1);
        this.findItemsToDisplay(var4, var1);
        if (!this.displayItems.isEmpty()) {
            this.displayCyclingItems(var1);
        } else {
            ShowTradesToPlayer.clearHeldItem(var1);
            this.lookTime = Math.min(this.lookTime, 40);
        }
        --this.lookTime;
    }

    @Override
    public void stop(ServerLevel var0, Villager var1, long var2) {
        super.stop(var0, var1, var2);
        var1.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        ShowTradesToPlayer.clearHeldItem(var1);
        this.playerItemStack = null;
    }

    private void findItemsToDisplay(LivingEntity var0, Villager var1) {
        boolean var2 = false;
        ItemStack var3 = var0.getMainHandItem();
        if (this.playerItemStack == null || !ItemStack.isSameItem(this.playerItemStack, var3)) {
            this.playerItemStack = var3;
            var2 = true;
            this.displayItems.clear();
        }
        if (var2 && !this.playerItemStack.isEmpty()) {
            this.updateDisplayItems(var1);
            if (!this.displayItems.isEmpty()) {
                this.lookTime = 900;
                this.displayFirstItem(var1);
            }
        }
    }

    private void displayFirstItem(Villager var0) {
        ShowTradesToPlayer.displayAsHeldItem(var0, this.displayItems.get(0));
    }

    private void updateDisplayItems(Villager var0) {
        for (MerchantOffer var2 : var0.getOffers()) {
            if (var2.isOutOfStock() || !this.playerItemStackMatchesCostOfOffer(var2)) continue;
            this.displayItems.add(var2.assemble());
        }
    }

    private boolean playerItemStackMatchesCostOfOffer(MerchantOffer var0) {
        return ItemStack.isSameItem(this.playerItemStack, var0.getCostA()) || ItemStack.isSameItem(this.playerItemStack, var0.getCostB());
    }

    private static void clearHeldItem(Villager var0) {
        var0.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        var0.setDropChance(EquipmentSlot.MAINHAND, 0.085f);
    }

    private static void displayAsHeldItem(Villager var0, ItemStack var1) {
        var0.setItemSlot(EquipmentSlot.MAINHAND, var1);
        var0.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    private LivingEntity lookAtTarget(Villager var0) {
        Brain<Villager> var1 = var0.getBrain();
        LivingEntity var2 = var1.getMemory(MemoryModuleType.INTERACTION_TARGET).get();
        var1.setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(var2, true));
        return var2;
    }

    private void displayCyclingItems(Villager var0) {
        if (this.displayItems.size() >= 2 && ++this.cycleCounter >= 40) {
            ++this.displayIndex;
            this.cycleCounter = 0;
            if (this.displayIndex > this.displayItems.size() - 1) {
                this.displayIndex = 0;
            }
            ShowTradesToPlayer.displayAsHeldItem(var0, this.displayItems.get(this.displayIndex));
        }
    }

    @Override
    public /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    public /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Villager)livingEntity, l);
    }
}

