/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.SpearAttack;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jspecify.annotations.Nullable;

public class SpearApproach
extends Behavior<PathfinderMob> {
    double speedModifierWhenRepositioning;
    float approachDistanceSq;

    public SpearApproach(double var0, float var2) {
        super(Map.of(MemoryModuleType.SPEAR_STATUS, MemoryStatus.VALUE_ABSENT));
        this.speedModifierWhenRepositioning = var0;
        this.approachDistanceSq = var2 * var2;
    }

    private boolean ableToAttack(PathfinderMob var0) {
        return this.getTarget(var0) != null && var0.getMainHandItem().has(DataComponents.KINETIC_WEAPON);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, PathfinderMob var1) {
        return this.ableToAttack(var1) && !var1.isUsingItem();
    }

    @Override
    protected void start(ServerLevel var0, PathfinderMob var1, long var2) {
        var1.setAggressive(true);
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_STATUS, SpearAttack.SpearStatus.APPROACH);
        super.start(var0, var1, var2);
    }

    private @Nullable LivingEntity getTarget(PathfinderMob var0) {
        return var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, PathfinderMob var1, long var2) {
        return this.ableToAttack(var1) && this.farEnough(var1);
    }

    private boolean farEnough(PathfinderMob var0) {
        LivingEntity var1 = this.getTarget(var0);
        double var2 = var0.distanceToSqr(var1.getX(), var1.getY(), var1.getZ());
        return var2 > (double)this.approachDistanceSq;
    }

    @Override
    protected void tick(ServerLevel var0, PathfinderMob var1, long var2) {
        LivingEntity var4 = this.getTarget(var1);
        Entity var5 = var1.getRootVehicle();
        float var6 = 1.0f;
        if (var5 instanceof Mob) {
            Mob var7 = (Mob)var5;
            var6 = var7.chargeSpeedModifier();
        }
        var1.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(var4, true));
        var1.getNavigation().moveTo(var4, (double)var6 * this.speedModifierWhenRepositioning);
    }

    @Override
    protected void stop(ServerLevel var0, PathfinderMob var1, long var2) {
        var1.getNavigation().stop();
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_STATUS, SpearAttack.SpearStatus.CHARGING);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        return this.canStillUse(serverLevel, (PathfinderMob)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (PathfinderMob)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (PathfinderMob)livingEntity, l);
    }
}

