/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class SpearAttack
extends Behavior<PathfinderMob> {
    public static final int MIN_REPOSITION_DISTANCE = 6;
    public static final int MAX_REPOSITION_DISTANCE = 7;
    double speedModifierWhenCharging;
    double speedModifierWhenRepositioning;
    float approachDistanceSq;
    float targetInRangeRadiusSq;

    public SpearAttack(double var0, double var2, float var4, float var5) {
        super(Map.of(MemoryModuleType.SPEAR_STATUS, MemoryStatus.VALUE_PRESENT));
        this.speedModifierWhenCharging = var0;
        this.speedModifierWhenRepositioning = var2;
        this.approachDistanceSq = var4 * var4;
        this.targetInRangeRadiusSq = var5 * var5;
    }

    private @Nullable LivingEntity getTarget(PathfinderMob var0) {
        return var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    private boolean ableToAttack(PathfinderMob var0) {
        return this.getTarget(var0) != null && var0.getMainHandItem().has(DataComponents.KINETIC_WEAPON);
    }

    private int getKineticWeaponUseDuration(PathfinderMob var0) {
        return Optional.ofNullable(var0.getMainHandItem().get(DataComponents.KINETIC_WEAPON)).map(KineticWeapon::computeDamageUseDuration).orElse(0);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, PathfinderMob var1) {
        return var1.getBrain().getMemory(MemoryModuleType.SPEAR_STATUS).orElse(SpearStatus.APPROACH) == SpearStatus.CHARGING && this.ableToAttack(var1) && !var1.isUsingItem();
    }

    @Override
    protected void start(ServerLevel var0, PathfinderMob var1, long var2) {
        var1.setAggressive(true);
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_ENGAGE_TIME, this.getKineticWeaponUseDuration(var1));
        var1.getBrain().eraseMemory(MemoryModuleType.SPEAR_CHARGE_POSITION);
        var1.startUsingItem(InteractionHand.MAIN_HAND);
        super.start(var0, var1, var2);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, PathfinderMob var1, long var2) {
        return var1.getBrain().getMemory(MemoryModuleType.SPEAR_ENGAGE_TIME).orElse(0) > 0 && this.ableToAttack(var1);
    }

    @Override
    protected void tick(ServerLevel var0, PathfinderMob var1, long var2) {
        LivingEntity var4 = this.getTarget(var1);
        double var5 = var1.distanceToSqr(var4.getX(), var4.getY(), var4.getZ());
        Entity var7 = var1.getRootVehicle();
        float var8 = 1.0f;
        if (var7 instanceof Mob) {
            Mob var9 = (Mob)var7;
            var8 = var9.chargeSpeedModifier();
        }
        int var9 = var1.isPassenger() ? 2 : 0;
        var1.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(var4, true));
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_ENGAGE_TIME, var1.getBrain().getMemory(MemoryModuleType.SPEAR_ENGAGE_TIME).orElse(0) - 1);
        Vec3 var10 = var1.getBrain().getMemory(MemoryModuleType.SPEAR_CHARGE_POSITION).orElse(null);
        if (var10 != null) {
            var1.getNavigation().moveTo(var10.x, var10.y, var10.z, (double)var8 * this.speedModifierWhenRepositioning);
            if (var1.getNavigation().isDone()) {
                var1.getBrain().eraseMemory(MemoryModuleType.SPEAR_CHARGE_POSITION);
            }
        } else {
            var1.getNavigation().moveTo(var4, (double)var8 * this.speedModifierWhenCharging);
            if (var5 < (double)this.targetInRangeRadiusSq || var1.getNavigation().isDone()) {
                double var11 = Math.sqrt(var5);
                Vec3 var13 = LandRandomPos.getPosAway(var1, (double)(6 + var9) - var11, (double)(7 + var9) - var11, 7, var4.position());
                var1.getBrain().setMemory(MemoryModuleType.SPEAR_CHARGE_POSITION, var13);
            }
        }
    }

    @Override
    protected void stop(ServerLevel var0, PathfinderMob var1, long var2) {
        var1.getNavigation().stop();
        var1.stopUsingItem();
        var1.getBrain().eraseMemory(MemoryModuleType.SPEAR_CHARGE_POSITION);
        var1.getBrain().eraseMemory(MemoryModuleType.SPEAR_ENGAGE_TIME);
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_STATUS, SpearStatus.RETREAT);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        return this.canStillUse(serverLevel, (PathfinderMob)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (PathfinderMob)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (PathfinderMob)livingEntity, l);
    }

    public static enum SpearStatus {
        APPROACH,
        CHARGING,
        RETREAT;

    }
}

