/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class Swim<T extends Mob>
extends Behavior<T> {
    private final float chance;

    public Swim(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
        this.chance = var0;
    }

    public static <T extends Mob> boolean shouldSwim(T var0) {
        return var0.isInWater() && var0.getFluidHeight(FluidTags.WATER) > var0.getFluidJumpThreshold() || var0.isInLava();
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Mob var1) {
        return Swim.shouldSwim(var1);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Mob var1, long var2) {
        return this.checkExtraStartConditions(var0, var1);
    }

    @Override
    protected void tick(ServerLevel var0, Mob var1, long var2) {
        if (var1.getRandom().nextFloat() < this.chance) {
            var1.getJumpControl().jump();
        }
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.tick(serverLevel, (Mob)livingEntity, l);
    }
}

