/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.apache.commons.lang3.mutable.MutableLong;

public class TryFindLand {
    private static final int COOLDOWN_TICKS = 60;

    public static BehaviorControl<PathfinderMob> create(int var0, float var1) {
        MutableLong var2 = new MutableLong(0L);
        return BehaviorBuilder.create(var32 -> var32.group(var32.absent(MemoryModuleType.ATTACK_TARGET), var32.absent(MemoryModuleType.WALK_TARGET), var32.registered(MemoryModuleType.LOOK_TARGET)).apply((Applicative)var32, (var3, var4, var52) -> (var5, var6, var7) -> {
            if (!var5.getFluidState(var6.blockPosition()).is(FluidTags.WATER)) {
                return false;
            }
            if (var7 < var2.longValue()) {
                var2.setValue(var7 + 60L);
                return true;
            }
            BlockPos var9 = var6.blockPosition();
            BlockPos.MutableBlockPos var10 = new BlockPos.MutableBlockPos();
            CollisionContext var11 = CollisionContext.of(var6);
            for (BlockPos var13 : BlockPos.withinManhattan(var9, var0, var0, var0)) {
                if (var13.getX() == var9.getX() && var13.getZ() == var9.getZ()) continue;
                BlockState var14 = var5.getBlockState(var13);
                BlockState var15 = var5.getBlockState(var10.setWithOffset((Vec3i)var13, Direction.DOWN));
                if (var14.is(Blocks.WATER) || !var5.getFluidState(var13).isEmpty() || !var14.getCollisionShape(var5, var13, var11).isEmpty() || !var15.isFaceSturdy(var5, var10, Direction.UP)) continue;
                BlockPos var16 = var13.immutable();
                var52.set(new BlockPosTracker(var16));
                var4.set(new WalkTarget(new BlockPosTracker(var16), var1, 1));
                break;
            }
            var2.setValue(var7 + 60L);
            return true;
        }));
    }
}

