/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.control;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.Control;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MoveControl
implements Control {
    public static final float MIN_SPEED = 5.0E-4f;
    public static final float MIN_SPEED_SQR = 2.5000003E-7f;
    protected static final int MAX_TURN = 90;
    protected final Mob mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected double speedModifier;
    protected float strafeForwards;
    protected float strafeRight;
    protected Operation operation = Operation.WAIT;

    public MoveControl(Mob var0) {
        this.mob = var0;
    }

    public boolean hasWanted() {
        return this.operation == Operation.MOVE_TO;
    }

    public double getSpeedModifier() {
        return this.speedModifier;
    }

    public void setWantedPosition(double var0, double var2, double var4, double var6) {
        this.wantedX = var0;
        this.wantedY = var2;
        this.wantedZ = var4;
        this.speedModifier = var6;
        if (this.operation != Operation.JUMPING) {
            this.operation = Operation.MOVE_TO;
        }
    }

    public void strafe(float var0, float var1) {
        this.operation = Operation.STRAFE;
        this.strafeForwards = var0;
        this.strafeRight = var1;
        this.speedModifier = 0.25;
    }

    public void tick() {
        if (this.operation == Operation.STRAFE) {
            float var8;
            float var0 = (float)this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED);
            float var1 = (float)this.speedModifier * var0;
            float var2 = this.strafeForwards;
            float var3 = this.strafeRight;
            float var4 = Mth.sqrt(var2 * var2 + var3 * var3);
            if (var4 < 1.0f) {
                var4 = 1.0f;
            }
            var4 = var1 / var4;
            float var5 = Mth.sin(this.mob.getYRot() * ((float)Math.PI / 180));
            float var6 = Mth.cos(this.mob.getYRot() * ((float)Math.PI / 180));
            float var7 = (var2 *= var4) * var6 - (var3 *= var4) * var5;
            if (!this.isWalkable(var7, var8 = var3 * var6 + var2 * var5)) {
                this.strafeForwards = 1.0f;
                this.strafeRight = 0.0f;
            }
            this.mob.setSpeed(var1);
            this.mob.setZza(this.strafeForwards);
            this.mob.setXxa(this.strafeRight);
            this.operation = Operation.WAIT;
        } else if (this.operation == Operation.MOVE_TO) {
            this.operation = Operation.WAIT;
            double var0 = this.wantedX - this.mob.getX();
            double var2 = this.wantedZ - this.mob.getZ();
            double var4 = this.wantedY - this.mob.getY();
            double var6 = var0 * var0 + var4 * var4 + var2 * var2;
            if (var6 < 2.500000277905201E-7) {
                this.mob.setZza(0.0f);
                return;
            }
            float var8 = (float)(Mth.atan2(var2, var0) * 57.2957763671875) - 90.0f;
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), var8, 90.0f));
            this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            BlockPos var9 = this.mob.blockPosition();
            BlockState var10 = this.mob.level().getBlockState(var9);
            VoxelShape var11 = var10.getCollisionShape(this.mob.level(), var9);
            if (var4 > (double)this.mob.maxUpStep() && var0 * var0 + var2 * var2 < (double)Math.max(1.0f, this.mob.getBbWidth()) || !var11.isEmpty() && this.mob.getY() < var11.max(Direction.Axis.Y) + (double)var9.getY() && !var10.is(BlockTags.DOORS) && !var10.is(BlockTags.FENCES)) {
                this.mob.getJumpControl().jump();
                this.operation = Operation.JUMPING;
            }
        } else if (this.operation == Operation.JUMPING) {
            this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            if (this.mob.onGround() || this.mob.isInLiquid() && this.mob.isAffectedByFluids()) {
                this.operation = Operation.WAIT;
            }
        } else {
            this.mob.setZza(0.0f);
        }
    }

    private boolean isWalkable(float var0, float var1) {
        NodeEvaluator var3;
        PathNavigation var2 = this.mob.getNavigation();
        return var2 == null || (var3 = var2.getNodeEvaluator()) == null || var3.getPathType(this.mob, BlockPos.containing(this.mob.getX() + (double)var0, this.mob.getBlockY(), this.mob.getZ() + (double)var1)) == PathType.WALKABLE;
    }

    protected float rotlerp(float var0, float var1, float var2) {
        float var4;
        float var3 = Mth.wrapDegrees(var1 - var0);
        if (var3 > var2) {
            var3 = var2;
        }
        if (var3 < -var2) {
            var3 = -var2;
        }
        if ((var4 = var0 + var3) < 0.0f) {
            var4 += 360.0f;
        } else if (var4 > 360.0f) {
            var4 -= 360.0f;
        }
        return var4;
    }

    public double getWantedX() {
        return this.wantedX;
    }

    public double getWantedY() {
        return this.wantedY;
    }

    public double getWantedZ() {
        return this.wantedZ;
    }

    public void setWait() {
        this.operation = Operation.WAIT;
    }

    protected static enum Operation {
        WAIT,
        MOVE_TO,
        STRAFE,
        JUMPING;

    }
}

