/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.List;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import org.jspecify.annotations.Nullable;

public class FollowParentGoal
extends Goal {
    public static final int HORIZONTAL_SCAN_RANGE = 8;
    public static final int VERTICAL_SCAN_RANGE = 4;
    public static final int DONT_FOLLOW_IF_CLOSER_THAN = 3;
    private final Animal animal;
    private @Nullable Animal parent;
    private final double speedModifier;
    private int timeToRecalcPath;

    public FollowParentGoal(Animal var0, double var1) {
        this.animal = var0;
        this.speedModifier = var1;
    }

    @Override
    public boolean canUse() {
        if (this.animal.getAge() >= 0) {
            return false;
        }
        List<?> var0 = this.animal.level().getEntitiesOfClass(this.animal.getClass(), this.animal.getBoundingBox().inflate(8.0, 4.0, 8.0));
        Animal var1 = null;
        double var2 = Double.MAX_VALUE;
        for (Animal var5 : var0) {
            double var6;
            if (var5.getAge() < 0 || (var6 = this.animal.distanceToSqr(var5)) > var2) continue;
            var2 = var6;
            var1 = var5;
        }
        if (var1 == null) {
            return false;
        }
        if (var2 < 9.0) {
            return false;
        }
        this.parent = var1;
        return true;
    }

    @Override
    public boolean canContinueToUse() {
        if (this.animal.getAge() >= 0) {
            return false;
        }
        if (!this.parent.isAlive()) {
            return false;
        }
        double var0 = this.animal.distanceToSqr(this.parent);
        return !(var0 < 9.0) && !(var0 > 256.0);
    }

    @Override
    public void start() {
        this.timeToRecalcPath = 0;
    }

    @Override
    public void stop() {
        this.parent = null;
    }

    @Override
    public void tick() {
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.adjustedTickDelay(10);
        this.animal.getNavigation().moveTo(this.parent, this.speedModifier);
    }
}

