/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class MoveBackToVillageGoal
extends RandomStrollGoal {
    private static final int MAX_XZ_DIST = 10;
    private static final int MAX_Y_DIST = 7;

    public MoveBackToVillageGoal(PathfinderMob var0, double var1, boolean var3) {
        super(var0, var1, 10, var3);
    }

    @Override
    public boolean canUse() {
        BlockPos var1;
        ServerLevel var0 = (ServerLevel)this.mob.level();
        if (var0.isVillage(var1 = this.mob.blockPosition())) {
            return false;
        }
        return super.canUse();
    }

    @Override
    protected @Nullable Vec3 getPosition() {
        BlockPos var1;
        SectionPos var2;
        ServerLevel var0 = (ServerLevel)this.mob.level();
        SectionPos var3 = BehaviorUtils.findSectionClosestToVillage(var0, var2 = SectionPos.of(var1 = this.mob.blockPosition()), 2);
        if (var3 != var2) {
            return DefaultRandomPos.getPosTowards(this.mob, 10, 7, Vec3.atBottomCenterOf(var3.center()), 1.5707963705062866);
        }
        return null;
    }
}

