/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class RandomStrollGoal
extends Goal {
    public static final int DEFAULT_INTERVAL = 120;
    protected final PathfinderMob mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    private final boolean checkNoActionTime;

    public RandomStrollGoal(PathfinderMob var0, double var1) {
        this(var0, var1, 120);
    }

    public RandomStrollGoal(PathfinderMob var0, double var1, int var3) {
        this(var0, var1, var3, true);
    }

    public RandomStrollGoal(PathfinderMob var0, double var1, int var3, boolean var4) {
        this.mob = var0;
        this.speedModifier = var1;
        this.interval = var3;
        this.checkNoActionTime = var4;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean canUse() {
        Vec3 var0;
        if (this.mob.hasControllingPassenger()) {
            return false;
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.mob.getNoActionTime() >= 100) {
                return false;
            }
            if (this.mob.getRandom().nextInt(RandomStrollGoal.reducedTickDelay(this.interval)) != 0) {
                return false;
            }
        }
        if ((var0 = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = var0.x;
        this.wantedY = var0.y;
        this.wantedZ = var0.z;
        this.forceTrigger = false;
        return true;
    }

    protected @Nullable Vec3 getPosition() {
        return DefaultRandomPos.getPos(this.mob, 10, 7);
    }

    @Override
    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone() && !this.mob.hasControllingPassenger();
    }

    @Override
    public void start() {
        this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    @Override
    public void stop() {
        this.mob.getNavigation().stop();
        super.stop();
    }

    public void trigger() {
        this.forceTrigger = true;
    }

    public void setInterval(int var0) {
        this.interval = var0;
    }
}

