/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class SpearUseGoal<T extends Monster>
extends Goal {
    static final int MIN_REPOSITION_DISTANCE = 6;
    static final int MAX_REPOSITION_DISTANCE = 7;
    static final int MIN_COOLDOWN_DISTANCE = 9;
    static final int MAX_COOLDOWN_DISTANCE = 11;
    static final double MAX_FLEEING_TIME = SpearUseGoal.reducedTickDelay(100);
    private final T mob;
    private @Nullable SpearUseState state;
    double speedModifierWhenCharging;
    double speedModifierWhenRepositioning;
    float approachDistanceSq;
    float targetInRangeRadiusSq;

    public SpearUseGoal(T var0, double var1, double var3, float var5, float var6) {
        this.mob = var0;
        this.speedModifierWhenCharging = var1;
        this.speedModifierWhenRepositioning = var3;
        this.approachDistanceSq = var5 * var5;
        this.targetInRangeRadiusSq = var6 * var6;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean canUse() {
        return this.ableToAttack() && !((LivingEntity)this.mob).isUsingItem();
    }

    private boolean ableToAttack() {
        return ((Mob)this.mob).getTarget() != null && ((LivingEntity)this.mob).getMainHandItem().has(DataComponents.KINETIC_WEAPON);
    }

    private int getKineticWeaponUseDuration() {
        int var0 = Optional.ofNullable(((LivingEntity)this.mob).getMainHandItem().get(DataComponents.KINETIC_WEAPON)).map(KineticWeapon::computeDamageUseDuration).orElse(0);
        return SpearUseGoal.reducedTickDelay(var0);
    }

    @Override
    public boolean canContinueToUse() {
        return this.state != null && !this.state.done && this.ableToAttack();
    }

    @Override
    public void start() {
        super.start();
        ((Mob)this.mob).setAggressive(true);
        this.state = new SpearUseState();
    }

    @Override
    public void stop() {
        super.stop();
        ((Mob)this.mob).getNavigation().stop();
        ((Mob)this.mob).setAggressive(false);
        this.state = null;
        ((LivingEntity)this.mob).stopUsingItem();
    }

    @Override
    public void tick() {
        double var6;
        if (this.state == null) {
            return;
        }
        LivingEntity var0 = ((Mob)this.mob).getTarget();
        double var1 = ((Entity)this.mob).distanceToSqr(var0.getX(), var0.getY(), var0.getZ());
        Entity var3 = ((Entity)this.mob).getRootVehicle();
        float var4 = 1.0f;
        if (var3 instanceof Mob) {
            Mob var5 = (Mob)var3;
            var4 = var5.chargeSpeedModifier();
        }
        int var5 = ((Entity)this.mob).isPassenger() ? 2 : 0;
        ((Mob)this.mob).lookAt(var0, 30.0f, 30.0f);
        ((Mob)this.mob).getLookControl().setLookAt(var0, 30.0f, 30.0f);
        if (this.state.notEngagedYet()) {
            if (var1 > (double)this.approachDistanceSq) {
                ((Mob)this.mob).getNavigation().moveTo(var0, (double)var4 * this.speedModifierWhenRepositioning);
                return;
            }
            this.state.startEngagement(this.getKineticWeaponUseDuration());
            ((LivingEntity)this.mob).startUsingItem(InteractionHand.MAIN_HAND);
        }
        if (this.state.tickAndCheckEngagement()) {
            ((LivingEntity)this.mob).stopUsingItem();
            var6 = Math.sqrt(var1);
            this.state.awayPos = LandRandomPos.getPosAway(this.mob, Math.max(0.0, (double)(9 + var5) - var6), Math.max(1.0, (double)(11 + var5) - var6), 7, var0.position());
            this.state.fleeingTime = 1;
        }
        if (this.state.tickAndCheckFleeing()) {
            return;
        }
        if (this.state.awayPos != null) {
            ((Mob)this.mob).getNavigation().moveTo(this.state.awayPos.x, this.state.awayPos.y, this.state.awayPos.z, (double)var4 * this.speedModifierWhenRepositioning);
            if (((Mob)this.mob).getNavigation().isDone()) {
                if (this.state.fleeingTime > 0) {
                    this.state.done = true;
                    return;
                }
                this.state.awayPos = null;
            }
        } else {
            ((Mob)this.mob).getNavigation().moveTo(var0, (double)var4 * this.speedModifierWhenCharging);
            if (var1 < (double)this.targetInRangeRadiusSq || ((Mob)this.mob).getNavigation().isDone()) {
                var6 = Math.sqrt(var1);
                this.state.awayPos = LandRandomPos.getPosAway(this.mob, (double)(6 + var5) - var6, (double)(7 + var5) - var6, 7, var0.position());
            }
        }
    }

    public static class SpearUseState {
        private int engageTime = -1;
        int fleeingTime = -1;
        @Nullable Vec3 awayPos;
        boolean done = false;

        public boolean notEngagedYet() {
            return this.engageTime < 0;
        }

        public void startEngagement(int var0) {
            this.engageTime = var0;
        }

        public boolean tickAndCheckEngagement() {
            if (this.engageTime > 0) {
                --this.engageTime;
                if (this.engageTime == 0) {
                    return true;
                }
            }
            return false;
        }

        public boolean tickAndCheckFleeing() {
            if (this.fleeingTime > 0) {
                ++this.fleeingTime;
                if ((double)this.fleeingTime > MAX_FLEEING_TIME) {
                    this.done = true;
                    return true;
                }
            }
            return false;
        }
    }
}

