/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.golem.IronGolem;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public class DefendVillageTargetGoal
extends TargetGoal {
    private final IronGolem golem;
    private @Nullable LivingEntity potentialTarget;
    private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);

    public DefendVillageTargetGoal(IronGolem entityirongolem) {
        super(entityirongolem, false, true);
        this.golem = entityirongolem;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    @Override
    public boolean canUse() {
        Player player;
        AABB axisalignedbb = this.golem.getBoundingBox().inflate(10.0, 8.0, 10.0);
        ServerLevel worldserver = DefendVillageTargetGoal.getServerLevel(this.golem);
        List<Villager> list = worldserver.getNearbyEntities(Villager.class, this.attackTargeting, this.golem, axisalignedbb);
        List<Player> list1 = worldserver.getNearbyPlayers(this.attackTargeting, this.golem, axisalignedbb);
        for (LivingEntity livingEntity : list) {
            Villager entityvillager = (Villager)livingEntity;
            for (Player entityhuman : list1) {
                int i = entityvillager.getPlayerReputation(entityhuman);
                if (i > -100) continue;
                this.potentialTarget = entityhuman;
            }
        }
        if (this.potentialTarget == null) {
            return false;
        }
        LivingEntity entityliving1 = this.potentialTarget;
        return !(entityliving1 instanceof Player) || !(player = (Player)entityliving1).isSpectator() && !player.isCreative();
    }

    @Override
    public void start() {
        this.golem.setTarget(this.potentialTarget, EntityTargetEvent.TargetReason.DEFEND_VILLAGE, true);
        super.start();
    }
}

