/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.scores.PlayerTeam;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public abstract class TargetGoal
extends Goal {
    private static final int EMPTY_REACH_CACHE = 0;
    private static final int CAN_REACH_CACHE = 1;
    private static final int CANT_REACH_CACHE = 2;
    protected final Mob mob;
    protected final boolean mustSee;
    private final boolean mustReach;
    private int reachCache;
    private int reachCacheTime;
    private int unseenTicks;
    protected @Nullable LivingEntity targetMob;
    protected int unseenMemoryTicks = 60;

    public TargetGoal(Mob entityinsentient, boolean flag) {
        this(entityinsentient, flag, false);
    }

    public TargetGoal(Mob entityinsentient, boolean flag, boolean flag1) {
        this.mob = entityinsentient;
        this.mustSee = flag;
        this.mustReach = flag1;
    }

    @Override
    public boolean canContinueToUse() {
        LivingEntity entityliving = this.mob.getTarget();
        if (entityliving == null) {
            entityliving = this.targetMob;
        }
        if (entityliving == null) {
            return false;
        }
        if (!this.mob.canAttack(entityliving)) {
            return false;
        }
        PlayerTeam scoreboardteambase = this.mob.getTeam();
        PlayerTeam scoreboardteambase1 = entityliving.getTeam();
        if (scoreboardteambase != null && scoreboardteambase1 == scoreboardteambase) {
            return false;
        }
        double d0 = this.getFollowDistance();
        if (this.mob.distanceToSqr(entityliving) > d0 * d0) {
            return false;
        }
        if (this.mustSee) {
            if (this.mob.getSensing().hasLineOfSight(entityliving)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > TargetGoal.reducedTickDelay(this.unseenMemoryTicks)) {
                return false;
            }
        }
        this.mob.setTarget(entityliving, EntityTargetEvent.TargetReason.CLOSEST_ENTITY, true);
        return true;
    }

    protected double getFollowDistance() {
        return this.mob.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    @Override
    public void start() {
        this.reachCache = 0;
        this.reachCacheTime = 0;
        this.unseenTicks = 0;
    }

    @Override
    public void stop() {
        this.mob.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
        this.targetMob = null;
    }

    protected boolean canAttack(@Nullable LivingEntity entityliving, TargetingConditions pathfindertargetcondition) {
        if (entityliving == null) {
            return false;
        }
        if (!pathfindertargetcondition.test(TargetGoal.getServerLevel(this.mob), this.mob, entityliving)) {
            return false;
        }
        if (!this.mob.isWithinHome(entityliving.blockPosition())) {
            return false;
        }
        if (this.mustReach) {
            if (--this.reachCacheTime <= 0) {
                this.reachCache = 0;
            }
            if (this.reachCache == 0) {
                int n = this.reachCache = this.canReach(entityliving) ? 1 : 2;
            }
            if (this.reachCache == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean canReach(LivingEntity entityliving) {
        int j;
        this.reachCacheTime = TargetGoal.reducedTickDelay(10 + this.mob.getRandom().nextInt(5));
        Path pathentity = this.mob.getNavigation().createPath(entityliving, 0);
        if (pathentity == null) {
            return false;
        }
        Node pathpoint = pathentity.getEndNode();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.x - entityliving.getBlockX();
        return (double)(i * i + (j = pathpoint.z - entityliving.getBlockZ()) * j) <= 2.25;
    }

    public TargetGoal setUnseenMemoryTicks(int i) {
        this.unseenMemoryTicks = i;
        return this;
    }
}

