/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class GoalUtils {
    public static boolean hasGroundPathNavigation(Mob var0) {
        return var0.getNavigation().canNavigateGround();
    }

    public static boolean mobRestricted(PathfinderMob var0, double var1) {
        return var0.hasHome() && var0.getHomePosition().closerToCenterThan(var0.position(), (double)var0.getHomeRadius() + var1 + 1.0);
    }

    public static boolean isOutsideLimits(BlockPos var0, PathfinderMob var1) {
        return var1.level().isOutsideBuildHeight(var0.getY());
    }

    public static boolean isRestricted(boolean var0, PathfinderMob var1, BlockPos var2) {
        return var0 && !var1.isWithinHome(var2);
    }

    public static boolean isRestricted(boolean var0, PathfinderMob var1, Vec3 var2) {
        return var0 && !var1.isWithinHome(var2);
    }

    public static boolean isNotStable(PathNavigation var0, BlockPos var1) {
        return !var0.isStableDestination(var1);
    }

    public static boolean isWater(PathfinderMob var0, BlockPos var1) {
        return var0.level().getFluidState(var1).is(FluidTags.WATER);
    }

    public static boolean hasMalus(PathfinderMob var0, BlockPos var1) {
        return var0.getPathfindingMalus(WalkNodeEvaluator.getPathTypeStatic(var0, var1)) != 0.0f;
    }

    public static boolean isSolid(PathfinderMob var0, BlockPos var1) {
        return var0.level().getBlockState(var1).isSolid();
    }
}

