/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class LandRandomPos {
    public static @Nullable Vec3 getPos(PathfinderMob var0, int var1, int var2) {
        return LandRandomPos.getPos(var0, var1, var2, var0::getWalkTargetValue);
    }

    public static @Nullable Vec3 getPos(PathfinderMob var0, int var1, int var2, ToDoubleFunction<BlockPos> var3) {
        boolean var4 = GoalUtils.mobRestricted(var0, var1);
        return RandomPos.generateRandomPos(() -> {
            BlockPos var4 = RandomPos.generateRandomDirection(var0.getRandom(), var1, var2);
            BlockPos var5 = LandRandomPos.generateRandomPosTowardDirection(var0, var1, var4, var4);
            if (var5 == null) {
                return null;
            }
            return LandRandomPos.movePosUpOutOfSolid(var0, var5);
        }, var3);
    }

    public static @Nullable Vec3 getPosTowards(PathfinderMob var0, int var1, int var2, Vec3 var3) {
        Vec3 var4 = var3.subtract(var0.getX(), var0.getY(), var0.getZ());
        boolean var5 = GoalUtils.mobRestricted(var0, var1);
        return LandRandomPos.getPosInDirection(var0, 0.0, var1, var2, var4, var5);
    }

    public static @Nullable Vec3 getPosAway(PathfinderMob var0, int var1, int var2, Vec3 var3) {
        return LandRandomPos.getPosAway(var0, 0.0, var1, var2, var3);
    }

    public static @Nullable Vec3 getPosAway(PathfinderMob var0, double var1, double var3, int var5, Vec3 var6) {
        Vec3 var7 = var0.position().subtract(var6);
        if (var7.length() == 0.0) {
            var7 = new Vec3(var0.getRandom().nextDouble() - 0.5, 0.0, var0.getRandom().nextDouble() - 0.5);
        }
        boolean var8 = GoalUtils.mobRestricted(var0, var3);
        return LandRandomPos.getPosInDirection(var0, var1, var3, var5, var7, var8);
    }

    private static @Nullable Vec3 getPosInDirection(PathfinderMob var0, double var1, double var3, int var5, Vec3 var6, boolean var7) {
        return RandomPos.generateRandomPos(var0, () -> {
            BlockPos var8 = RandomPos.generateRandomDirectionWithinRadians(var0.getRandom(), var1, var3, var5, 0, var6.x, var6.z, 1.5707963705062866);
            if (var8 == null) {
                return null;
            }
            BlockPos var9 = LandRandomPos.generateRandomPosTowardDirection(var0, var3, var7, var8);
            if (var9 == null) {
                return null;
            }
            return LandRandomPos.movePosUpOutOfSolid(var0, var9);
        });
    }

    public static @Nullable BlockPos movePosUpOutOfSolid(PathfinderMob var0, BlockPos var12) {
        if (GoalUtils.isWater(var0, var12 = RandomPos.moveUpOutOfSolid(var12, var0.level().getMaxY(), var1 -> GoalUtils.isSolid(var0, var1))) || GoalUtils.hasMalus(var0, var12)) {
            return null;
        }
        return var12;
    }

    public static @Nullable BlockPos generateRandomPosTowardDirection(PathfinderMob var0, double var1, boolean var3, BlockPos var4) {
        BlockPos var5 = RandomPos.generateRandomPosTowardDirection(var0, var1, var0.getRandom(), var4);
        if (GoalUtils.isOutsideLimits(var5, var0) || GoalUtils.isRestricted(var3, var0, var5) || GoalUtils.isNotStable(var0.getNavigation(), var5)) {
            return null;
        }
        return var5;
    }
}

