/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.equine;

import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.animal.equine.Donkey;
import net.minecraft.world.entity.animal.equine.Markings;
import net.minecraft.world.entity.animal.equine.Mule;
import net.minecraft.world.entity.animal.equine.Variant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class Horse
extends AbstractHorse {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(Horse.class, EntityDataSerializers.INT);
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.HORSE.getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityType.HORSE.getHeight() + 0.125f, 0.0f)).scale(0.5f);
    private static final int DEFAULT_VARIANT = 0;

    public Horse(EntityType<? extends Horse> var0, Level var1) {
        super((EntityType<? extends AbstractHorse>)var0, var1);
        this.setPathfindingMalus(PathType.DANGER_OTHER, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, -1.0f);
    }

    @Override
    protected void randomizeAttributes(RandomSource var0) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(Horse.generateMaxHealth(var0::nextInt));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(Horse.generateSpeed(var0::nextDouble));
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(Horse.generateJumpStrength(var0::nextDouble));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ID_TYPE_VARIANT, 0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Variant", this.getTypeVariant());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setTypeVariant(var0.getIntOr("Variant", 0));
    }

    private void setTypeVariant(int var0) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, var0);
    }

    private int getTypeVariant() {
        return this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public void setVariantAndMarkings(Variant var0, Markings var1) {
        this.setTypeVariant(var0.getId() & 0xFF | var1.getId() << 8 & 0xFF00);
    }

    public Variant getVariant() {
        return Variant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(Variant var0) {
        this.setTypeVariant(var0.getId() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.HORSE_VARIANT) {
            return Horse.castComponentValue(var0, this.getVariant());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.HORSE_VARIANT);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.HORSE_VARIANT) {
            this.setVariant(Horse.castComponentValue(DataComponents.HORSE_VARIANT, var1));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    public Markings getMarkings() {
        return Markings.byId((this.getTypeVariant() & 0xFF00) >> 8);
    }

    @Override
    protected void playGallopSound(SoundType var0) {
        super.playGallopSound(var0);
        if (this.random.nextInt(10) == 0) {
            this.playSound(SoundEvents.HORSE_BREATHE, var0.getVolume() * 0.6f, var0.getPitch());
        }
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.HORSE_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.HORSE_DEATH;
    }

    @Override
    protected SoundEvent getEatingSound() {
        return SoundEvents.HORSE_EAT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource var0) {
        return SoundEvents.HORSE_HURT;
    }

    @Override
    protected SoundEvent getAngrySound() {
        return SoundEvents.HORSE_ANGRY;
    }

    @Override
    public InteractionResult mobInteract(Player var0, InteractionHand var1) {
        boolean var2;
        boolean bl = var2 = !this.isBaby() && this.isTamed() && var0.isSecondaryUseActive();
        if (this.isVehicle() || var2) {
            return super.mobInteract(var0, var1);
        }
        ItemStack var3 = var0.getItemInHand(var1);
        if (!var3.isEmpty()) {
            if (this.isFood(var3)) {
                return this.fedFood(var0, var3);
            }
            if (!this.isTamed()) {
                this.makeMad();
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    public boolean canMate(Animal var0) {
        if (var0 == this) {
            return false;
        }
        if (var0 instanceof Donkey || var0 instanceof Horse) {
            return this.canParent() && ((AbstractHorse)var0).canParent();
        }
        return false;
    }

    @Override
    public @Nullable AgeableMob getBreedOffspring(ServerLevel var0, AgeableMob var1) {
        if (var1 instanceof Donkey) {
            Mule var2 = EntityType.MULE.create(var0, EntitySpawnReason.BREEDING);
            if (var2 != null) {
                this.setOffspringAttributes(var1, var2);
            }
            return var2;
        }
        Horse var2 = (Horse)var1;
        Horse var3 = EntityType.HORSE.create(var0, EntitySpawnReason.BREEDING);
        if (var3 != null) {
            int var5 = this.random.nextInt(9);
            Variant var4 = var5 < 4 ? this.getVariant() : (var5 < 8 ? var2.getVariant() : Util.getRandom(Variant.values(), this.random));
            int var7 = this.random.nextInt(5);
            Markings var6 = var7 < 2 ? this.getMarkings() : (var7 < 4 ? var2.getMarkings() : Util.getRandom(Markings.values(), this.random));
            var3.setVariantAndMarkings(var4, var6);
            this.setOffspringAttributes(var1, var3);
        }
        return var3;
    }

    @Override
    public boolean canUseSlot(EquipmentSlot var0) {
        return true;
    }

    @Override
    protected void hurtArmor(DamageSource var0, float var1) {
        this.doHurtEquipment(var0, var1, EquipmentSlot.BODY);
    }

    @Override
    public @Nullable SpawnGroupData finalizeSpawn(ServerLevelAccessor var0, DifficultyInstance var1, EntitySpawnReason var2, @Nullable SpawnGroupData var3) {
        Variant var5;
        RandomSource var4 = var0.getRandom();
        if (var3 instanceof HorseGroupData) {
            var5 = ((HorseGroupData)var3).variant;
        } else {
            var5 = Util.getRandom(Variant.values(), var4);
            var3 = new HorseGroupData(var5);
        }
        this.setVariantAndMarkings(var5, Util.getRandom(Markings.values(), var4));
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose var0) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(var0);
    }

    public static class HorseGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Variant variant;

        public HorseGroupData(Variant var0) {
            super(true);
            this.variant = var0;
        }
    }
}

