/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.equine;

import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.animal.equine.SkeletonHorse;
import net.minecraft.world.entity.monster.skeleton.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.jspecify.annotations.Nullable;

public class SkeletonTrapGoal
extends Goal {
    private final SkeletonHorse horse;

    public SkeletonTrapGoal(SkeletonHorse entityhorseskeleton) {
        this.horse = entityhorseskeleton;
    }

    @Override
    public boolean canUse() {
        return this.horse.level().hasNearbyAlivePlayer(this.horse.getX(), this.horse.getY(), this.horse.getZ(), 10.0);
    }

    @Override
    public void tick() {
        ServerLevel worldserver = (ServerLevel)this.horse.level();
        DifficultyInstance difficultydamagescaler = worldserver.getCurrentDifficultyAt(this.horse.blockPosition());
        this.horse.setTrap(false);
        this.horse.setTamed(true);
        this.horse.setAge(0);
        LightningBolt entitylightning = EntityType.LIGHTNING_BOLT.create(worldserver, EntitySpawnReason.TRIGGERED);
        if (entitylightning != null) {
            entitylightning.snapTo(this.horse.getX(), this.horse.getY(), this.horse.getZ());
            entitylightning.setVisualOnly(true);
            worldserver.strikeLightning(entitylightning, LightningStrikeEvent.Cause.TRAP);
            Skeleton entityskeleton = this.createSkeleton(difficultydamagescaler, this.horse);
            if (entityskeleton != null) {
                entityskeleton.startRiding(this.horse);
                worldserver.addFreshEntityWithPassengers(entityskeleton, CreatureSpawnEvent.SpawnReason.TRAP);
                for (int i = 0; i < 3; ++i) {
                    Skeleton entityskeleton1;
                    AbstractHorse entityhorseabstract = this.createHorse(difficultydamagescaler);
                    if (entityhorseabstract == null || (entityskeleton1 = this.createSkeleton(difficultydamagescaler, entityhorseabstract)) == null) continue;
                    entityskeleton1.startRiding(entityhorseabstract);
                    entityhorseabstract.push(this.horse.getRandom().triangle(0.0, 1.1485), 0.0, this.horse.getRandom().triangle(0.0, 1.1485));
                    worldserver.addFreshEntityWithPassengers(entityhorseabstract, CreatureSpawnEvent.SpawnReason.JOCKEY);
                }
            }
        }
    }

    private @Nullable AbstractHorse createHorse(DifficultyInstance difficultydamagescaler) {
        SkeletonHorse entityhorseskeleton = EntityType.SKELETON_HORSE.create(this.horse.level(), EntitySpawnReason.TRIGGERED);
        if (entityhorseskeleton != null) {
            entityhorseskeleton.finalizeSpawn((ServerLevel)this.horse.level(), difficultydamagescaler, EntitySpawnReason.TRIGGERED, null);
            entityhorseskeleton.setPos(this.horse.getX(), this.horse.getY(), this.horse.getZ());
            entityhorseskeleton.invulnerableTime = 60;
            entityhorseskeleton.setPersistenceRequired();
            entityhorseskeleton.setTamed(true);
            entityhorseskeleton.setAge(0);
        }
        return entityhorseskeleton;
    }

    private @Nullable Skeleton createSkeleton(DifficultyInstance difficultydamagescaler, AbstractHorse entityhorseabstract) {
        Skeleton entityskeleton = EntityType.SKELETON.create(entityhorseabstract.level(), EntitySpawnReason.TRIGGERED);
        if (entityskeleton != null) {
            entityskeleton.finalizeSpawn((ServerLevel)entityhorseabstract.level(), difficultydamagescaler, EntitySpawnReason.TRIGGERED, null);
            entityskeleton.setPos(entityhorseabstract.getX(), entityhorseabstract.getY(), entityhorseabstract.getZ());
            entityskeleton.invulnerableTime = 60;
            entityskeleton.setPersistenceRequired();
            if (entityskeleton.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                entityskeleton.setItemSlot(EquipmentSlot.HEAD, new ItemStack(Items.IRON_HELMET));
            }
            this.enchant(entityskeleton, EquipmentSlot.MAINHAND, difficultydamagescaler);
            this.enchant(entityskeleton, EquipmentSlot.HEAD, difficultydamagescaler);
        }
        return entityskeleton;
    }

    private void enchant(Skeleton entityskeleton, EquipmentSlot enumitemslot, DifficultyInstance difficultydamagescaler) {
        ItemStack itemstack = entityskeleton.getItemBySlot(enumitemslot);
        itemstack.set(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        EnchantmentHelper.enchantItemFromProvider(itemstack, entityskeleton.level().registryAccess(), VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, difficultydamagescaler, entityskeleton.getRandom());
        entityskeleton.setItemSlot(enumitemslot, itemstack);
    }
}

