/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.nautilus;

import com.mojang.serialization.Dynamic;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.nautilus.NautilusAi;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class Nautilus
extends AbstractNautilus {
    private static final int NAUTILUS_TOTAL_AIR_SUPPLY = 300;

    public Nautilus(EntityType<? extends Nautilus> var0, Level var1) {
        super((EntityType<? extends AbstractNautilus>)var0, var1);
    }

    protected Brain.Provider<Nautilus> brainProvider() {
        return NautilusAi.brainProvider();
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> var0) {
        return NautilusAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public Brain<Nautilus> getBrain() {
        return super.getBrain();
    }

    @Override
    public @Nullable Nautilus getBreedOffspring(ServerLevel var0, AgeableMob var1) {
        Nautilus var2 = EntityType.NAUTILUS.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null && this.isTame()) {
            var2.setOwnerReference(this.getOwnerReference());
            var2.setTame(true, true);
        }
        return var2;
    }

    @Override
    protected void customServerAiStep(ServerLevel var0) {
        ProfilerFiller var1 = Profiler.get();
        var1.push("nautilusBrain");
        this.getBrain().tick(var0, this);
        var1.pop();
        var1.push("nautilusActivityUpdate");
        NautilusAi.updateActivity(this);
        var1.pop();
        super.customServerAiStep(var0);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        if (this.isBaby()) {
            return this.isUnderWater() ? SoundEvents.BABY_NAUTILUS_AMBIENT : SoundEvents.BABY_NAUTILUS_AMBIENT_ON_LAND;
        }
        return this.isUnderWater() ? SoundEvents.NAUTILUS_AMBIENT : SoundEvents.NAUTILUS_AMBIENT_ON_LAND;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource var0) {
        if (this.isBaby()) {
            return this.isUnderWater() ? SoundEvents.BABY_NAUTILUS_HURT : SoundEvents.BABY_NAUTILUS_HURT_ON_LAND;
        }
        return this.isUnderWater() ? SoundEvents.NAUTILUS_HURT : SoundEvents.NAUTILUS_HURT_ON_LAND;
    }

    @Override
    protected SoundEvent getDeathSound() {
        if (this.isBaby()) {
            return this.isUnderWater() ? SoundEvents.BABY_NAUTILUS_DEATH : SoundEvents.BABY_NAUTILUS_DEATH_ON_LAND;
        }
        return this.isUnderWater() ? SoundEvents.NAUTILUS_DEATH : SoundEvents.NAUTILUS_DEATH_ON_LAND;
    }

    @Override
    protected SoundEvent getDashSound() {
        return this.isUnderWater() ? SoundEvents.NAUTILUS_DASH : SoundEvents.NAUTILUS_DASH_ON_LAND;
    }

    @Override
    protected SoundEvent getDashReadySound() {
        return this.isUnderWater() ? SoundEvents.NAUTILUS_DASH_READY : SoundEvents.NAUTILUS_DASH_READY_ON_LAND;
    }

    @Override
    protected void playEatingSound() {
        SoundEvent var0 = this.isBaby() ? SoundEvents.BABY_NAUTILUS_EAT : SoundEvents.NAUTILUS_EAT;
        this.makeSound(var0);
    }

    @Override
    protected SoundEvent getSwimSound() {
        return this.isBaby() ? SoundEvents.BABY_NAUTILUS_SWIM : SoundEvents.NAUTILUS_SWIM;
    }

    @Override
    public int getMaxAirSupply() {
        return 300;
    }

    protected void handleAirSupply(ServerLevel var0, int var1) {
        if (this.isAlive() && !this.isInWater()) {
            this.setAirSupply(var1 - 1);
            if (this.getAirSupply() <= -20) {
                this.setAirSupply(0);
                this.hurtServer(var0, this.damageSources().dryOut(), 2.0f);
            }
        } else {
            this.setAirSupply(300);
        }
    }

    @Override
    public void baseTick() {
        Level level;
        int var0 = this.getAirSupply();
        super.baseTick();
        if (!this.isNoAi() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel var1 = (ServerLevel)level;
            this.handleAirSupply(var1, var0);
        }
    }

    @Override
    public boolean canBeLeashed() {
        return !this.isAggravated();
    }

    @Override
    public /* synthetic */ @Nullable AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }
}

