/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.animal.equine.Llama;
import net.minecraft.world.entity.animal.turtle.Turtle;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.skeleton.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public class Wolf
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Long> DATA_ANGER_END_TIME = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.LONG);
    private static final EntityDataAccessor<Holder<WolfVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.WOLF_VARIANT);
    private static final EntityDataAccessor<Holder<WolfSoundVariant>> DATA_SOUND_VARIANT_ID = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.WOLF_SOUND_VARIANT);
    public static final TargetingConditions.Selector PREY_SELECTOR = (entityliving, worldserver) -> {
        EntityType<?> entitytypes = entityliving.getType();
        return entitytypes == EntityType.SHEEP || entitytypes == EntityType.RABBIT || entitytypes == EntityType.FOX;
    };
    private static final float START_HEALTH = 8.0f;
    private static final float TAME_HEALTH = 40.0f;
    private static final float ARMOR_REPAIR_UNIT = 0.125f;
    public static final float DEFAULT_TAIL_ANGLE = 0.62831855f;
    private static final DyeColor DEFAULT_COLLAR_COLOR = DyeColor.RED;
    private float interestedAngle;
    private float interestedAngleO;
    public boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds(20, 39);
    private @Nullable EntityReference<LivingEntity> persistentAngerTarget;

    public Wolf(EntityType<? extends Wolf> entitytypes, Level world) {
        super((EntityType<? extends TamableAnimal>)entitytypes, world);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new FloatGoal(this));
        this.goalSelector.addGoal(1, new TamableAnimal.TamableAnimalPanicGoal(1.5, DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(2, new SitWhenOrderedToGoal(this));
        this.goalSelector.addGoal(3, new WolfAvoidEntityGoal(this, Llama.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(4, new LeapAtTargetGoal(this, 0.4f));
        this.goalSelector.addGoal(5, new MeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(6, new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, new BreedGoal(this, 1.0));
        this.goalSelector.addGoal(8, new WaterAvoidingRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(9, new BegGoal(this, 8.0f));
        this.goalSelector.addGoal(10, new LookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(1, new OwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, new OwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(3, new HurtByTargetGoal(this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, new NearestAttackableTargetGoal<Player>(this, Player.class, 10, true, false, this::isAngryAt));
        this.targetSelector.addGoal(5, new NonTameRandomTargetGoal<Animal>(this, Animal.class, false, PREY_SELECTOR));
        this.targetSelector.addGoal(6, new NonTameRandomTargetGoal<Turtle>(this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, new NearestAttackableTargetGoal<AbstractSkeleton>((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(8, new ResetUniversalAngerTargetGoal<Wolf>(this, true));
    }

    public Identifier getTexture() {
        WolfVariant wolfvariant = this.getVariant().value();
        return this.isTame() ? wolfvariant.assetInfo().tame().texturePath() : (this.isAngry() ? wolfvariant.assetInfo().angry().texturePath() : wolfvariant.assetInfo().wild().texturePath());
    }

    public Holder<WolfVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<WolfVariant> holder) {
        this.entityData.set(DATA_VARIANT_ID, holder);
    }

    private Holder<WolfSoundVariant> getSoundVariant() {
        return this.entityData.get(DATA_SOUND_VARIANT_ID);
    }

    private void setSoundVariant(Holder<WolfSoundVariant> holder) {
        this.entityData.set(DATA_SOUND_VARIANT_ID, holder);
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.WOLF_VARIANT ? Wolf.castComponentValue(datacomponenttype, this.getVariant()) : (datacomponenttype == DataComponents.WOLF_SOUND_VARIANT ? Wolf.castComponentValue(datacomponenttype, this.getSoundVariant()) : (datacomponenttype == DataComponents.WOLF_COLLAR ? Wolf.castComponentValue(datacomponenttype, this.getCollarColor()) : super.get(datacomponenttype)));
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter datacomponentgetter) {
        this.applyImplicitComponentIfPresent(datacomponentgetter, DataComponents.WOLF_VARIANT);
        this.applyImplicitComponentIfPresent(datacomponentgetter, DataComponents.WOLF_SOUND_VARIANT);
        this.applyImplicitComponentIfPresent(datacomponentgetter, DataComponents.WOLF_COLLAR);
        super.applyImplicitComponents(datacomponentgetter);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.WOLF_VARIANT) {
            this.setVariant(Wolf.castComponentValue(DataComponents.WOLF_VARIANT, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.WOLF_SOUND_VARIANT) {
            this.setSoundVariant(Wolf.castComponentValue(DataComponents.WOLF_SOUND_VARIANT, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.WOLF_COLLAR) {
            this.setCollarColor(Wolf.castComponentValue(DataComponents.WOLF_COLLAR, t0));
            return true;
        }
        return super.applyImplicitComponent(datacomponenttype, t0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, 0.3f).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        HolderLookup.RegistryLookup iregistry = this.registryAccess().lookupOrThrow(Registries.WOLF_SOUND_VARIANT);
        datawatcher_a.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.registryAccess(), WolfVariants.DEFAULT));
        EntityDataAccessor<Holder<WolfSoundVariant>> datawatcherobject = DATA_SOUND_VARIANT_ID;
        Optional optional = iregistry.get(WolfSoundVariants.CLASSIC);
        Objects.requireNonNull(iregistry);
        datawatcher_a.define(datawatcherobject, (Holder)optional.or(((Registry)iregistry)::getAny).orElseThrow());
        datawatcher_a.define(DATA_INTERESTED_ID, false);
        datawatcher_a.define(DATA_COLLAR_COLOR, DEFAULT_COLLAR_COLOR.getId());
        datawatcher_a.define(DATA_ANGER_END_TIME, -1L);
    }

    @Override
    protected void playStepSound(BlockPos blockposition, BlockState iblockdata) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.store("CollarColor", DyeColor.LEGACY_ID_CODEC, this.getCollarColor());
        VariantUtils.writeVariant(valueoutput, this.getVariant());
        this.addPersistentAngerSaveData(valueoutput);
        this.getSoundVariant().unwrapKey().ifPresent(resourcekey -> valueoutput.store("sound_variant", ResourceKey.codec(Registries.WOLF_SOUND_VARIANT), resourcekey));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        VariantUtils.readVariant(valueinput, Registries.WOLF_VARIANT).ifPresent(this::setVariant);
        this.setCollarColor(valueinput.read("CollarColor", DyeColor.LEGACY_ID_CODEC).orElse(DEFAULT_COLLAR_COLOR));
        this.readPersistentAngerSaveData(this.level(), valueinput);
        valueinput.read("sound_variant", ResourceKey.codec(Registries.WOLF_SOUND_VARIANT)).flatMap(resourcekey -> this.registryAccess().lookupOrThrow(Registries.WOLF_SOUND_VARIANT).get((ResourceKey)resourcekey)).ifPresent(this::setSoundVariant);
    }

    @Override
    public @Nullable SpawnGroupData finalizeSpawn(ServerLevelAccessor worldaccess, DifficultyInstance difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable SpawnGroupData groupdataentity) {
        if (groupdataentity instanceof WolfPackData) {
            WolfPackData entitywolf_b = (WolfPackData)groupdataentity;
            this.setVariant(entitywolf_b.type);
        } else {
            Optional optional = VariantUtils.selectVariantToSpawn(SpawnContext.create(worldaccess, this.blockPosition()), Registries.WOLF_VARIANT);
            if (optional.isPresent()) {
                this.setVariant(optional.get());
                groupdataentity = new WolfPackData(optional.get());
            }
        }
        this.setSoundVariant(WolfSoundVariants.pickRandomSoundVariant(this.registryAccess(), worldaccess.getRandom()));
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return this.isAngry() ? this.getSoundVariant().value().growlSound().value() : (this.random.nextInt(3) == 0 ? (this.isTame() && this.getHealth() < 20.0f ? this.getSoundVariant().value().whineSound().value() : this.getSoundVariant().value().pantSound().value()) : this.getSoundVariant().value().ambientSound().value());
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return this.canArmorAbsorb(damagesource) ? SoundEvents.WOLF_ARMOR_DAMAGE : this.getSoundVariant().value().hurtSound().value();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return this.getSoundVariant().value().deathSound().value();
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide() && this.isWet && !this.isShaking && !this.isPathFinding() && this.onGround()) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            this.level().broadcastEntityEvent(this, (byte)8);
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isAlive()) {
            this.interestedAngleO = this.interestedAngle;
            this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
            if (this.isInWaterOrRain()) {
                this.isWet = true;
                if (this.isShaking && !this.level().isClientSide()) {
                    this.level().broadcastEntityEvent(this, (byte)56);
                    this.cancelShake();
                }
            } else if ((this.isWet || this.isShaking) && this.isShaking) {
                if (this.shakeAnim == 0.0f) {
                    this.playSound(SoundEvents.WOLF_SHAKE, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    this.gameEvent(GameEvent.ENTITY_ACTION);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.isWet = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                }
                if (this.shakeAnim > 0.4f) {
                    float f = (float)this.getY();
                    int i = (int)(Mth.sin((this.shakeAnim - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3 vec3d = this.getDeltaMovement();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                        float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                        this.level().addParticle(ParticleTypes.SPLASH, this.getX() + (double)f1, f + 0.8f, this.getZ() + (double)f2, vec3d.x, vec3d.y, vec3d.z);
                    }
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    @Override
    public void die(DamageSource damagesource) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.die(damagesource);
    }

    public float getWetShade(float f) {
        return !this.isWet ? 1.0f : Math.min(0.75f + Mth.lerp(f, this.shakeAnimO, this.shakeAnim) / 2.0f * 0.25f, 1.0f);
    }

    public float getShakeAnim(float f) {
        return Mth.lerp(f, this.shakeAnimO, this.shakeAnim);
    }

    public float getHeadRollAngle(float f) {
        return Mth.lerp(f, this.interestedAngleO, this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    @Override
    public int getMaxHeadXRot() {
        return this.isInSittingPose() ? 20 : super.getMaxHeadXRot();
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (this.isInvulnerableTo(worldserver, damagesource)) {
            return false;
        }
        boolean result = super.hurtServer(worldserver, damagesource, f);
        if (!result) {
            return result;
        }
        this.setOrderedToSit(false);
        return result;
    }

    @Override
    public boolean actuallyHurt(ServerLevel worldserver, DamageSource damagesource, float f, EntityDamageEvent event) {
        if (!this.canArmorAbsorb(damagesource)) {
            return super.actuallyHurt(worldserver, damagesource, f, event);
        }
        if (event.isCancelled()) {
            return false;
        }
        ItemStack itemstack = this.getBodyArmorItem();
        int i = itemstack.getDamageValue();
        int j = itemstack.getMaxDamage();
        itemstack.hurtAndBreak(Mth.ceil(f), (LivingEntity)this, EquipmentSlot.BODY);
        if (Crackiness.WOLF_ARMOR.byDamage(i, j) != Crackiness.WOLF_ARMOR.byDamage(this.getBodyArmorItem())) {
            this.playSound(SoundEvents.WOLF_ARMOR_CRACK);
            worldserver.sendParticles(new ItemParticleOption(ParticleTypes.ITEM, Items.ARMADILLO_SCUTE.getDefaultInstance()), this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.2, 0.1, 0.2, 0.1);
        }
        return false;
    }

    private boolean canArmorAbsorb(DamageSource damagesource) {
        return this.getBodyArmorItem().is(Items.WOLF_ARMOR) && !damagesource.is(DamageTypeTags.BYPASSES_WOLF_ARMOR);
    }

    @Override
    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(40.0);
            this.setHealth(this.getMaxHealth());
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(8.0);
        }
    }

    @Override
    protected void hurtArmor(DamageSource damagesource, float f) {
        this.doHurtEquipment(damagesource, f, EquipmentSlot.BODY);
    }

    @Override
    protected boolean canShearEquipment(Player entityhuman) {
        return this.isOwnedBy(entityhuman);
    }

    @Override
    public InteractionResult mobInteract(Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        Item item = itemstack.getItem();
        if (this.isTame()) {
            if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(entityhuman, enumhand, itemstack);
                FoodProperties foodinfo = itemstack.get(DataComponents.FOOD);
                float f = foodinfo != null ? (float)foodinfo.nutrition() : 1.0f;
                this.heal(2.0f * f, EntityRegainHealthEvent.RegainReason.EATING);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof DyeItem) {
                DyeItem itemdye = (DyeItem)item;
                if (this.isOwnedBy(entityhuman)) {
                    DyeColor enumcolor = itemdye.getDyeColor();
                    if (enumcolor != this.getCollarColor()) {
                        this.setCollarColor(enumcolor);
                        itemstack.consume(1, entityhuman);
                        return InteractionResult.SUCCESS;
                    }
                    return super.mobInteract(entityhuman, enumhand);
                }
            }
            if (this.isEquippableInSlot(itemstack, EquipmentSlot.BODY) && !this.isWearingBodyArmor() && this.isOwnedBy(entityhuman) && !this.isBaby()) {
                this.setBodyArmorItem(itemstack.copyWithCount(1));
                itemstack.consume(1, entityhuman);
                return InteractionResult.SUCCESS;
            }
            if (this.isInSittingPose() && this.isWearingBodyArmor() && this.isOwnedBy(entityhuman) && this.getBodyArmorItem().isDamaged() && this.getBodyArmorItem().isValidRepairItem(itemstack)) {
                itemstack.shrink(1);
                this.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
                ItemStack itemstack1 = this.getBodyArmorItem();
                int i = (int)((float)itemstack1.getMaxDamage() * 0.125f);
                itemstack1.setDamageValue(Math.max(0, itemstack1.getDamageValue() - i));
                return InteractionResult.SUCCESS;
            }
            InteractionResult enuminteractionresult = super.mobInteract(entityhuman, enumhand);
            if (!enuminteractionresult.consumesAction() && this.isOwnedBy(entityhuman)) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
                return InteractionResult.SUCCESS.withoutItem();
            }
            return enuminteractionresult;
        }
        if (!this.level().isClientSide() && itemstack.is(Items.BONE) && !this.isAngry()) {
            itemstack.consume(1, entityhuman);
            this.tryToTame(entityhuman);
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.mobInteract(entityhuman, enumhand);
    }

    private void tryToTame(Player entityhuman) {
        if (this.random.nextInt(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, entityhuman).isCancelled()) {
            this.tame(entityhuman);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent(this, (byte)7);
        } else {
            this.level().broadcastEntityEvent(this, (byte)6);
        }
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if (b0 == 56) {
            this.cancelShake();
        } else {
            super.handleEntityEvent(b0);
        }
    }

    public float getTailAngle() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        if (this.isTame()) {
            float f = this.getMaxHealth();
            float f1 = (f - this.getHealth()) / f;
            return (0.55f - f1 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(ItemTags.WOLF_FOOD);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 8;
    }

    @Override
    public long getPersistentAngerEndTime() {
        return this.entityData.get(DATA_ANGER_END_TIME);
    }

    @Override
    public void setPersistentAngerEndTime(long i) {
        this.entityData.set(DATA_ANGER_END_TIME, i);
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setTimeToRemainAngry(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    public @Nullable EntityReference<LivingEntity> getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable EntityReference<LivingEntity> entityreference) {
        this.persistentAngerTarget = entityreference;
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId(this.entityData.get(DATA_COLLAR_COLOR));
    }

    public void setCollarColor(DyeColor enumcolor) {
        this.entityData.set(DATA_COLLAR_COLOR, enumcolor.getId());
    }

    @Override
    public @Nullable Wolf getBreedOffspring(ServerLevel worldserver, AgeableMob entityageable) {
        Wolf entitywolf = EntityType.WOLF.create(worldserver, EntitySpawnReason.BREEDING);
        if (entitywolf != null && entityageable instanceof Wolf) {
            Wolf entitywolf1 = (Wolf)entityageable;
            if (this.random.nextBoolean()) {
                entitywolf.setVariant(this.getVariant());
            } else {
                entitywolf.setVariant(entitywolf1.getVariant());
            }
            if (this.isTame()) {
                entitywolf.setOwnerReference(this.getOwnerReference());
                entitywolf.setTame(true, true);
                DyeColor enumcolor = this.getCollarColor();
                DyeColor enumcolor1 = entitywolf1.getCollarColor();
                entitywolf.setCollarColor(DyeColor.getMixedColor(worldserver, enumcolor, enumcolor1));
            }
            entitywolf.setSoundVariant(WolfSoundVariants.pickRandomSoundVariant(this.registryAccess(), this.random));
        }
        return entitywolf;
    }

    public void setIsInterested(boolean flag) {
        this.entityData.set(DATA_INTERESTED_ID, flag);
    }

    @Override
    public boolean canMate(Animal entityanimal) {
        if (entityanimal == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(entityanimal instanceof Wolf)) {
            return false;
        }
        Wolf entitywolf = (Wolf)entityanimal;
        return !entitywolf.isTame() ? false : (entitywolf.isInSittingPose() ? false : this.isInLove() && entitywolf.isInLove());
    }

    public boolean isInterested() {
        return this.entityData.get(DATA_INTERESTED_ID);
    }

    @Override
    public boolean wantsToAttack(LivingEntity entityliving, LivingEntity entityliving1) {
        if (!(entityliving instanceof Creeper || entityliving instanceof Ghast || entityliving instanceof ArmorStand)) {
            TamableAnimal entitytameableanimal;
            AbstractHorse entityhorseabstract;
            if (entityliving instanceof Wolf) {
                Wolf entitywolf = (Wolf)entityliving;
                return !entitywolf.isTame() || entitywolf.getOwner() != entityliving1;
            }
            if (entityliving instanceof Player) {
                Player entityhuman1;
                Player entityhuman = (Player)entityliving;
                if (entityliving1 instanceof Player && !(entityhuman1 = (Player)entityliving1).canHarmPlayer(entityhuman)) {
                    return false;
                }
            }
            if (entityliving instanceof AbstractHorse && (entityhorseabstract = (AbstractHorse)entityliving).isTamed()) {
                return false;
            }
            if (entityliving instanceof TamableAnimal && (entitytameableanimal = (TamableAnimal)entityliving).isTame()) {
                boolean flag = false;
                return flag;
            }
            boolean flag = true;
            return flag;
        }
        return false;
    }

    @Override
    public boolean canBeLeashed() {
        return !this.isAngry();
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public static boolean checkWolfSpawnRules(EntityType<Wolf> entitytypes, LevelAccessor generatoraccess, EntitySpawnReason entityspawnreason, BlockPos blockposition, RandomSource randomsource) {
        return generatoraccess.getBlockState(blockposition.below()).is(BlockTags.WOLVES_SPAWNABLE_ON) && Wolf.isBrightEnoughToSpawn(generatoraccess, blockposition);
    }

    private class WolfAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Wolf wolf;

        public WolfAvoidEntityGoal(Wolf entitywolf, Class oclass, float f, double d0, double d1) {
            super(entitywolf, oclass, f, d0, d1);
            this.wolf = entitywolf;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && this.toAvoid instanceof Llama ? !this.wolf.isTame() && this.avoidLlama((Llama)this.toAvoid) : false;
        }

        private boolean avoidLlama(Llama entityllama) {
            return entityllama.getStrength() >= Wolf.this.random.nextInt(5);
        }

        @Override
        public void start() {
            Wolf.this.setTarget(null);
            super.start();
        }

        @Override
        public void tick() {
            Wolf.this.setTarget(null);
            super.tick();
        }
    }

    public static class WolfPackData
    extends AgeableMob.AgeableMobGroupData {
        public final Holder<WolfVariant> type;

        public WolfPackData(Holder<WolfVariant> holder) {
            super(false);
            this.type = holder;
        }
    }
}

