/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import net.minecraft.util.Mth;

public class DragonFlightHistory {
    public static final int LENGTH = 64;
    private static final int MASK = 63;
    private final Sample[] samples = new Sample[64];
    private int head = -1;

    public DragonFlightHistory() {
        Arrays.fill(this.samples, new Sample(0.0, 0.0f));
    }

    public void copyFrom(DragonFlightHistory var0) {
        System.arraycopy(var0.samples, 0, this.samples, 0, 64);
        this.head = var0.head;
    }

    public void record(double var0, float var2) {
        Sample var3 = new Sample(var0, var2);
        if (this.head < 0) {
            Arrays.fill(this.samples, var3);
        }
        if (++this.head == 64) {
            this.head = 0;
        }
        this.samples[this.head] = var3;
    }

    public Sample get(int var0) {
        return this.samples[this.head - var0 & 0x3F];
    }

    public Sample get(int var0, float var1) {
        Sample var2 = this.get(var0);
        Sample var3 = this.get(var0 + 1);
        return new Sample(Mth.lerp((double)var1, var3.y, var2.y), Mth.rotLerp(var1, var3.yRot, var2.yRot));
    }

    public static final class Sample
    extends Record {
        final double y;
        final float yRot;

        public Sample(double var0, float var2) {
            this.y = var0;
            this.yRot = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Sample.class, "y;yRot", "y", "yRot"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Sample.class, "y;yRot", "y", "yRot"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Sample.class, "y;yRot", "y", "yRot"}, this, var0);
        }

        public double y() {
            return this.y;
        }

        public float yRot() {
            return this.yRot;
        }
    }
}

