/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class DragonLandingApproachPhase
extends AbstractDragonPhaseInstance {
    private static final TargetingConditions NEAR_EGG_TARGETING = TargetingConditions.forCombat().ignoreLineOfSight();
    private @Nullable Path currentPath;
    private @Nullable Vec3 targetLocation;

    public DragonLandingApproachPhase(EnderDragon var0) {
        super(var0);
    }

    public EnderDragonPhase<DragonLandingApproachPhase> getPhase() {
        return EnderDragonPhase.LANDING_APPROACH;
    }

    @Override
    public void begin() {
        this.currentPath = null;
        this.targetLocation = null;
    }

    @Override
    public void doServerTick(ServerLevel var0) {
        double var1;
        double d = var1 = this.targetLocation == null ? 0.0 : this.targetLocation.distanceToSqr(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ());
        if (var1 < 100.0 || var1 > 22500.0 || this.dragon.horizontalCollision || this.dragon.verticalCollision) {
            this.findNewTarget(var0);
        }
    }

    @Override
    public @Nullable Vec3 getFlyTargetLocation() {
        return this.targetLocation;
    }

    private void findNewTarget(ServerLevel var0) {
        if (this.currentPath == null || this.currentPath.isDone()) {
            int var4;
            Object var5;
            int var1 = this.dragon.findClosestNode();
            BlockPos var2 = var0.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation(this.dragon.getFightOrigin()));
            Player var3 = var0.getNearestPlayer(NEAR_EGG_TARGETING, this.dragon, (double)var2.getX(), (double)var2.getY(), var2.getZ());
            if (var3 != null) {
                var5 = new Vec3(var3.getX(), 0.0, var3.getZ()).normalize();
                var4 = this.dragon.findClosestNode(-((Vec3)var5).x * 40.0, 105.0, -((Vec3)var5).z * 40.0);
            } else {
                var4 = this.dragon.findClosestNode(40.0, var2.getY(), 0.0);
            }
            var5 = new Node(var2.getX(), var2.getY(), var2.getZ());
            this.currentPath = this.dragon.findPath(var1, var4, (Node)var5);
            if (this.currentPath != null) {
                this.currentPath.advance();
            }
        }
        this.navigateToNextPathNode();
        if (this.currentPath != null && this.currentPath.isDone()) {
            this.dragon.getPhaseManager().setPhase(EnderDragonPhase.LANDING);
        }
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.isDone()) {
            double var5;
            BlockPos var0 = this.currentPath.getNextNodePos();
            this.currentPath.advance();
            double var1 = var0.getX();
            double var3 = var0.getZ();
            while ((var5 = (double)((float)var0.getY() + this.dragon.getRandom().nextFloat() * 20.0f)) < (double)var0.getY()) {
            }
            this.targetLocation = new Vec3(var1, var5, var3);
        }
    }
}

