/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.projectile.hurtingprojectile.DragonFireball;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class DragonStrafePlayerPhase
extends AbstractDragonPhaseInstance {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int FIREBALL_CHARGE_AMOUNT = 5;
    private int fireballCharge;
    private @Nullable Path currentPath;
    private @Nullable Vec3 targetLocation;
    private @Nullable LivingEntity attackTarget;
    private boolean holdingPatternClockwise;

    public DragonStrafePlayerPhase(EnderDragon var0) {
        super(var0);
    }

    @Override
    public void doServerTick(ServerLevel var0) {
        double var9;
        double var3;
        double var1;
        if (this.attackTarget == null) {
            LOGGER.warn("Skipping player strafe phase because no player was found");
            this.dragon.getPhaseManager().setPhase(EnderDragonPhase.HOLDING_PATTERN);
            return;
        }
        if (this.currentPath != null && this.currentPath.isDone()) {
            var1 = this.attackTarget.getX();
            var3 = this.attackTarget.getZ();
            double var5 = var1 - this.dragon.getX();
            double var7 = var3 - this.dragon.getZ();
            var9 = Math.sqrt(var5 * var5 + var7 * var7);
            double var11 = Math.min((double)0.4f + var9 / 80.0 - 1.0, 10.0);
            this.targetLocation = new Vec3(var1, this.attackTarget.getY() + var11, var3);
        }
        double d = var1 = this.targetLocation == null ? 0.0 : this.targetLocation.distanceToSqr(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ());
        if (var1 < 100.0 || var1 > 22500.0) {
            this.findNewTarget();
        }
        var3 = 64.0;
        if (this.attackTarget.distanceToSqr(this.dragon) < 4096.0) {
            if (this.dragon.hasLineOfSight(this.attackTarget)) {
                ++this.fireballCharge;
                Vec3 var5 = new Vec3(this.attackTarget.getX() - this.dragon.getX(), 0.0, this.attackTarget.getZ() - this.dragon.getZ()).normalize();
                Vec3 var6 = new Vec3(Mth.sin(this.dragon.getYRot() * ((float)Math.PI / 180)), 0.0, -Mth.cos(this.dragon.getYRot() * ((float)Math.PI / 180))).normalize();
                float var7 = (float)var6.dot(var5);
                float var8 = (float)(Math.acos(var7) * 57.2957763671875);
                var8 += 0.5f;
                if (this.fireballCharge >= 5 && var8 >= 0.0f && var8 < 10.0f) {
                    var9 = 1.0;
                    Vec3 var11 = this.dragon.getViewVector(1.0f);
                    double var12 = this.dragon.head.getX() - var11.x * 1.0;
                    double var14 = this.dragon.head.getY(0.5) + 0.5;
                    double var16 = this.dragon.head.getZ() - var11.z * 1.0;
                    double var18 = this.attackTarget.getX() - var12;
                    double var20 = this.attackTarget.getY(0.5) - var14;
                    double var22 = this.attackTarget.getZ() - var16;
                    Vec3 var24 = new Vec3(var18, var20, var22);
                    if (!this.dragon.isSilent()) {
                        var0.levelEvent(null, 1017, this.dragon.blockPosition(), 0);
                    }
                    DragonFireball var25 = new DragonFireball(var0, this.dragon, var24.normalize());
                    var25.snapTo(var12, var14, var16, 0.0f, 0.0f);
                    var0.addFreshEntity(var25);
                    this.fireballCharge = 0;
                    if (this.currentPath != null) {
                        while (!this.currentPath.isDone()) {
                            this.currentPath.advance();
                        }
                    }
                    this.dragon.getPhaseManager().setPhase(EnderDragonPhase.HOLDING_PATTERN);
                }
            } else if (this.fireballCharge > 0) {
                --this.fireballCharge;
            }
        } else if (this.fireballCharge > 0) {
            --this.fireballCharge;
        }
    }

    private void findNewTarget() {
        if (this.currentPath == null || this.currentPath.isDone()) {
            int var0;
            int var1 = var0 = this.dragon.findClosestNode();
            if (this.dragon.getRandom().nextInt(8) == 0) {
                this.holdingPatternClockwise = !this.holdingPatternClockwise;
                var1 += 6;
            }
            var1 = this.holdingPatternClockwise ? ++var1 : --var1;
            if (this.dragon.getDragonFight() == null || this.dragon.getDragonFight().getCrystalsAlive() <= 0) {
                var1 -= 12;
                var1 &= 7;
                var1 += 12;
            } else if ((var1 %= 12) < 0) {
                var1 += 12;
            }
            this.currentPath = this.dragon.findPath(var0, var1, null);
            if (this.currentPath != null) {
                this.currentPath.advance();
            }
        }
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.isDone()) {
            double var3;
            BlockPos var0 = this.currentPath.getNextNodePos();
            this.currentPath.advance();
            double var1 = var0.getX();
            double var5 = var0.getZ();
            while ((var3 = (double)((float)var0.getY() + this.dragon.getRandom().nextFloat() * 20.0f)) < (double)var0.getY()) {
            }
            this.targetLocation = new Vec3(var1, var3, var5);
        }
    }

    @Override
    public void begin() {
        this.fireballCharge = 0;
        this.targetLocation = null;
        this.currentPath = null;
        this.attackTarget = null;
    }

    public void setTarget(LivingEntity var0) {
        this.attackTarget = var0;
        int var1 = this.dragon.findClosestNode();
        int var2 = this.dragon.findClosestNode(this.attackTarget.getX(), this.attackTarget.getY(), this.attackTarget.getZ());
        int var3 = this.attackTarget.getBlockX();
        int var4 = this.attackTarget.getBlockZ();
        double var5 = (double)var3 - this.dragon.getX();
        double var7 = (double)var4 - this.dragon.getZ();
        double var9 = Math.sqrt(var5 * var5 + var7 * var7);
        double var11 = Math.min((double)0.4f + var9 / 80.0 - 1.0, 10.0);
        int var13 = Mth.floor(this.attackTarget.getY() + var11);
        Node var14 = new Node(var3, var13, var4);
        this.currentPath = this.dragon.findPath(var1, var2, var14);
        if (this.currentPath != null) {
            this.currentPath.advance();
            this.navigateToNextPathNode();
        }
    }

    @Override
    public @Nullable Vec3 getFlyTargetLocation() {
        return this.targetLocation;
    }

    public EnderDragonPhase<DragonStrafePlayerPhase> getPhase() {
        return EnderDragonPhase.STRAFE_PLAYER;
    }
}

