/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration.painting;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.util.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.painting.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class Painting
extends HangingEntity {
    private static final EntityDataAccessor<Holder<PaintingVariant>> DATA_PAINTING_VARIANT_ID = SynchedEntityData.defineId(Painting.class, EntityDataSerializers.PAINTING_VARIANT);
    public static final float DEPTH = 0.0625f;

    public Painting(EntityType<? extends Painting> entitytypes, Level world) {
        super((EntityType<? extends HangingEntity>)entitytypes, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_PAINTING_VARIANT_ID, VariantUtils.getAny(this.registryAccess(), Registries.PAINTING_VARIANT));
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        super.onSyncedDataUpdated(datawatcherobject);
        if (DATA_PAINTING_VARIANT_ID.equals(datawatcherobject)) {
            this.recalculateBoundingBox();
        }
    }

    public void setVariant(Holder<PaintingVariant> holder) {
        this.entityData.set(DATA_PAINTING_VARIANT_ID, holder);
    }

    public Holder<PaintingVariant> getVariant() {
        return this.entityData.get(DATA_PAINTING_VARIANT_ID);
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.PAINTING_VARIANT ? Painting.castComponentValue(datacomponenttype, this.getVariant()) : super.get(datacomponenttype);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter datacomponentgetter) {
        this.applyImplicitComponentIfPresent(datacomponentgetter, DataComponents.PAINTING_VARIANT);
        super.applyImplicitComponents(datacomponentgetter);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.PAINTING_VARIANT) {
            this.setVariant(Painting.castComponentValue(DataComponents.PAINTING_VARIANT, t0));
            return true;
        }
        return super.applyImplicitComponent(datacomponenttype, t0);
    }

    public static Optional<Painting> create(Level world, BlockPos blockposition, Direction enumdirection) {
        Painting entitypainting = new Painting(world, blockposition);
        ArrayList<Holder> list = new ArrayList<Holder>();
        Iterable<Holder<PaintingVariant>> iterable = world.registryAccess().lookupOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(PaintingVariantTags.PLACEABLE);
        Objects.requireNonNull(list);
        iterable.forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        entitypainting.setDirection(enumdirection);
        list.removeIf(holder -> {
            entitypainting.setVariant((Holder<PaintingVariant>)holder);
            return !entitypainting.survives();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i = list.stream().mapToInt(Painting::variantArea).max().orElse(0);
        list.removeIf(holder -> Painting.variantArea(holder) < i);
        Optional optional = Util.getRandomSafe(list, entitypainting.random);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        entitypainting.setVariant((Holder)optional.get());
        entitypainting.setDirection(enumdirection);
        return Optional.of(entitypainting);
    }

    private static int variantArea(Holder<PaintingVariant> holder) {
        return holder.value().area();
    }

    private Painting(Level world, BlockPos blockposition) {
        super((EntityType<? extends HangingEntity>)EntityType.PAINTING, world, blockposition);
    }

    public Painting(Level world, BlockPos blockposition, Direction enumdirection, Holder<PaintingVariant> holder) {
        this(world, blockposition);
        this.setVariant(holder);
        this.setDirection(enumdirection);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        valueoutput.store("facing", Direction.LEGACY_ID_CODEC_2D, this.getDirection());
        super.addAdditionalSaveData(valueoutput);
        VariantUtils.writeVariant(valueoutput, this.getVariant());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        Direction enumdirection = valueinput.read("facing", Direction.LEGACY_ID_CODEC_2D).orElse(Direction.SOUTH);
        super.readAdditionalSaveData(valueinput);
        this.setDirection(enumdirection);
        VariantUtils.readVariant(valueinput, Registries.PAINTING_VARIANT).ifPresent(this::setVariant);
    }

    @Override
    protected AABB calculateBoundingBox(BlockPos blockposition, Direction enumdirection) {
        PaintingVariant paintingvariant = this.getVariant().value();
        return Painting.calculateBoundingBoxStatic(blockposition, enumdirection, paintingvariant.width(), paintingvariant.height());
    }

    public static AABB calculateBoundingBoxStatic(BlockPos blockposition, Direction enumdirection, int width, int height) {
        float f = 0.46875f;
        Vec3 vec3d = Vec3.atCenterOf(blockposition).relative(enumdirection, -0.46875);
        double d0 = Painting.offsetForPaintingSize(width);
        double d1 = Painting.offsetForPaintingSize(height);
        Direction enumdirection1 = enumdirection.getCounterClockWise();
        Vec3 vec3d1 = vec3d.relative(enumdirection1, d0).relative(Direction.UP, d1);
        Direction.Axis enumdirection_enumaxis = enumdirection.getAxis();
        double d2 = enumdirection_enumaxis == Direction.Axis.X ? 0.0625 : (double)width;
        double d3 = height;
        double d4 = enumdirection_enumaxis == Direction.Axis.Z ? 0.0625 : (double)width;
        return AABB.ofSize(vec3d1, d2, d3, d4);
    }

    private static double offsetForPaintingSize(int i) {
        return i % 2 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void dropItem(ServerLevel worldserver, @Nullable Entity entity) {
        if (worldserver.getGameRules().get(GameRules.ENTITY_DROPS).booleanValue()) {
            Player entityhuman;
            this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
            if (entity instanceof Player && (entityhuman = (Player)entity).hasInfiniteMaterials()) {
                return;
            }
            this.spawnAtLocation(worldserver, Items.PAINTING);
        }
    }

    @Override
    public void playPlacementSound() {
        this.playSound(SoundEvents.PAINTING_PLACE, 1.0f, 1.0f);
    }

    @Override
    public void snapTo(double d0, double d1, double d2, float f, float f1) {
        this.setPos(d0, d1, d2);
    }

    @Override
    public Vec3 trackingPosition() {
        return Vec3.atLowerCornerOf(this.pos);
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entitytrackerentry) {
        return new ClientboundAddEntityPacket((Entity)this, this.getDirection().get3DDataValue(), this.getPos());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        this.setDirection(Direction.from3DDataValue(packetplayoutspawnentity.getData()));
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.PAINTING);
    }
}

