/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.gamerules.GameRules;

public abstract class Monster
extends PathfinderMob
implements Enemy {
    protected Monster(EntityType<? extends Monster> var0, Level var1) {
        super((EntityType<? extends PathfinderMob>)var0, var1);
        this.xpReward = 5;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    public void aiStep() {
        this.updateSwingTime();
        this.updateNoActionTime();
        super.aiStep();
    }

    protected void updateNoActionTime() {
        float var0 = this.getLightLevelDependentMagicValue();
        if (var0 > 0.5f) {
            this.noActionTime += 2;
        }
    }

    @Override
    protected SoundEvent getSwimSound() {
        return SoundEvents.HOSTILE_SWIM;
    }

    @Override
    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.HOSTILE_SPLASH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource var0) {
        return SoundEvents.HOSTILE_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.HOSTILE_DEATH;
    }

    @Override
    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.HOSTILE_SMALL_FALL, SoundEvents.HOSTILE_BIG_FALL);
    }

    @Override
    public float getWalkTargetValue(BlockPos var0, LevelReader var1) {
        return -var1.getPathfindingCostFromLightLevels(var0);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor var0, BlockPos var1, RandomSource var2) {
        if (var0.getBrightness(LightLayer.SKY, var1) > var2.nextInt(32)) {
            return false;
        }
        DimensionType var3 = var0.dimensionType();
        int var4 = var3.monsterSpawnBlockLightLimit();
        if (var4 < 15 && var0.getBrightness(LightLayer.BLOCK, var1) > var4) {
            return false;
        }
        int var5 = var0.getLevel().isThundering() ? var0.getMaxLocalRawBrightness(var1, 10) : var0.getMaxLocalRawBrightness(var1);
        return var5 <= var3.monsterSpawnLightTest().sample(var2);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends Mob> var0, ServerLevelAccessor var1, EntitySpawnReason var2, BlockPos var3, RandomSource var4) {
        return var1.getDifficulty() != Difficulty.PEACEFUL && (EntitySpawnReason.ignoresLightRequirements(var2) || Monster.isDarkEnoughToSpawn(var1, var3, var4)) && Monster.checkMobSpawnRules(var0, var1, var2, var3, var4);
    }

    public static boolean checkAnyLightMonsterSpawnRules(EntityType<? extends Monster> var0, LevelAccessor var1, EntitySpawnReason var2, BlockPos var3, RandomSource var4) {
        return var1.getDifficulty() != Difficulty.PEACEFUL && Monster.checkMobSpawnRules(var0, var1, var2, var3, var4);
    }

    public static boolean checkSurfaceMonstersSpawnRules(EntityType<? extends Mob> var0, ServerLevelAccessor var1, EntitySpawnReason var2, BlockPos var3, RandomSource var4) {
        return Monster.checkMonsterSpawnRules(var0, var1, var2, var3, var4) && (EntitySpawnReason.isSpawner(var2) || var1.canSeeSky(var3));
    }

    public static AttributeSupplier.Builder createMonsterAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE);
    }

    @Override
    public boolean shouldDropExperience() {
        return true;
    }

    @Override
    protected boolean shouldDropLoot(ServerLevel var0) {
        return var0.getGameRules().get(GameRules.MOB_DROPS);
    }

    public boolean isPreventingPlayerRest(ServerLevel var0, Player var1) {
        return true;
    }

    @Override
    public ItemStack getProjectile(ItemStack var0) {
        if (var0.getItem() instanceof ProjectileWeaponItem) {
            Predicate<ItemStack> var1 = ((ProjectileWeaponItem)var0.getItem()).getSupportedHeldProjectiles();
            ItemStack var2 = ProjectileWeaponItem.getHeldProjectile(this, var1);
            return var2.isEmpty() ? new ItemStack(Items.ARROW) : var2;
        }
        return ItemStack.EMPTY;
    }
}

