/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.schedule.Activity;

public class HoglinAi {
    public static final int REPELLENT_DETECTION_RANGE_HORIZONTAL = 8;
    public static final int REPELLENT_DETECTION_RANGE_VERTICAL = 4;
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds(5, 20);
    private static final int ATTACK_DURATION = 200;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_IDLING = 8;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_RETREATING = 15;
    private static final int ATTACK_INTERVAL = 40;
    private static final int BABY_ATTACK_INTERVAL = 15;
    private static final int REPELLENT_PACIFY_TIME = 200;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of(5, 16);
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING_REPELLENT = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_RETREATING = 1.3f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.4f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 0.6f;

    protected static Brain<?> makeBrain(Brain<Hoglin> var0) {
        HoglinAi.initCoreActivity(var0);
        HoglinAi.initIdleActivity(var0);
        HoglinAi.initFightActivity(var0);
        HoglinAi.initRetreatActivity(var0);
        var0.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var0.setDefaultActivity(Activity.IDLE);
        var0.useDefaultActivity();
        return var0;
    }

    private static void initCoreActivity(Brain<Hoglin> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Hoglin>>)ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<Hoglin> var0) {
        var0.addActivity(Activity.IDLE, 10, (ImmutableList<BehaviorControl<Hoglin>>)ImmutableList.of(BecomePassiveIfMemoryPresent.create(MemoryModuleType.NEAREST_REPELLENT, 200), (Object)new AnimalMakeLove(EntityType.HOGLIN, 0.6f, 2), SetWalkTargetAwayFrom.pos(MemoryModuleType.NEAREST_REPELLENT, 1.0f, 8, true), StartAttacking.create(HoglinAi::findNearestValidAttackTarget), BehaviorBuilder.triggerIf(Hoglin::isAdult, SetWalkTargetAwayFrom.entity(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, 0.4f, 8, false)), SetEntityLookTargetSometimes.create(8.0f, UniformInt.of(30, 60)), BabyFollowAdult.create(ADULT_FOLLOW_RANGE, 0.6f), HoglinAi.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<Hoglin> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, (ImmutableList<BehaviorControl<Hoglin>>)ImmutableList.of(BecomePassiveIfMemoryPresent.create(MemoryModuleType.NEAREST_REPELLENT, 200), (Object)new AnimalMakeLove(EntityType.HOGLIN, 0.6f, 2), SetWalkTargetFromAttackTargetIfTargetOutOfReach.create(1.0f), BehaviorBuilder.triggerIf(Hoglin::isAdult, MeleeAttack.create(40)), BehaviorBuilder.triggerIf(AgeableMob::isBaby, MeleeAttack.create(15)), StopAttackingIfTargetInvalid.create(), EraseMemoryIf.create(HoglinAi::isBreeding, MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initRetreatActivity(Brain<Hoglin> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, (ImmutableList<BehaviorControl<Hoglin>>)ImmutableList.of(SetWalkTargetAwayFrom.entity(MemoryModuleType.AVOID_TARGET, 1.3f, 15, false), HoglinAi.createIdleMovementBehaviors(), SetEntityLookTargetSometimes.create(8.0f, UniformInt.of(30, 60)), EraseMemoryIf.create(HoglinAi::wantsToStopFleeing, MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static RunOne<Hoglin> createIdleMovementBehaviors() {
        return new RunOne<Hoglin>((List<Pair<BehaviorControl<Hoglin>, Integer>>)ImmutableList.of((Object)Pair.of(RandomStroll.stroll(0.4f), (Object)2), (Object)Pair.of(SetWalkTargetFromLookTarget.create(0.4f, 3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    protected static void updateActivity(Hoglin var0) {
        Brain<Hoglin> var1 = var0.getBrain();
        Activity var2 = var1.getActiveNonCoreActivity().orElse(null);
        var1.setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.IDLE));
        Activity var3 = var1.getActiveNonCoreActivity().orElse(null);
        if (var2 != var3) {
            HoglinAi.getSoundForCurrentActivity(var0).ifPresent(var0::makeSound);
        }
        var0.setAggressive(var1.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    protected static void onHitTarget(Hoglin var0, LivingEntity var1) {
        if (var0.isBaby()) {
            return;
        }
        if (var1.getType() == EntityType.PIGLIN && HoglinAi.piglinsOutnumberHoglins(var0)) {
            HoglinAi.setAvoidTarget(var0, var1);
            HoglinAi.broadcastRetreat(var0, var1);
            return;
        }
        HoglinAi.broadcastAttackTarget(var0, var1);
    }

    private static void broadcastRetreat(Hoglin var0, LivingEntity var12) {
        HoglinAi.getVisibleAdultHoglins(var0).forEach(var1 -> HoglinAi.retreatFromNearestTarget(var1, var12));
    }

    private static void retreatFromNearestTarget(Hoglin var0, LivingEntity var1) {
        LivingEntity var2 = var1;
        Brain<Hoglin> var3 = var0.getBrain();
        var2 = BehaviorUtils.getNearestTarget(var0, var3.getMemory(MemoryModuleType.AVOID_TARGET), var2);
        var2 = BehaviorUtils.getNearestTarget(var0, var3.getMemory(MemoryModuleType.ATTACK_TARGET), var2);
        HoglinAi.setAvoidTarget(var0, var2);
    }

    private static void setAvoidTarget(Hoglin var0, LivingEntity var1) {
        var0.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        var0.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, var1, RETREAT_DURATION.sample(var0.level().random));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(ServerLevel var0, Hoglin var1) {
        if (HoglinAi.isPacified(var1) || HoglinAi.isBreeding(var1)) {
            return Optional.empty();
        }
        return var1.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
    }

    static boolean isPosNearNearestRepellent(Hoglin var0, BlockPos var1) {
        Optional<BlockPos> var2 = var0.getBrain().getMemory(MemoryModuleType.NEAREST_REPELLENT);
        return var2.isPresent() && var2.get().closerThan(var1, 8.0);
    }

    private static boolean wantsToStopFleeing(Hoglin var0) {
        return var0.isAdult() && !HoglinAi.piglinsOutnumberHoglins(var0);
    }

    private static boolean piglinsOutnumberHoglins(Hoglin var0) {
        int var2;
        if (var0.isBaby()) {
            return false;
        }
        int var1 = var0.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT).orElse(0);
        return var1 > (var2 = var0.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT).orElse(0) + 1);
    }

    protected static void wasHurtBy(ServerLevel var0, Hoglin var1, LivingEntity var2) {
        Brain<Hoglin> var3 = var1.getBrain();
        var3.eraseMemory(MemoryModuleType.PACIFIED);
        var3.eraseMemory(MemoryModuleType.BREED_TARGET);
        if (var1.isBaby()) {
            HoglinAi.retreatFromNearestTarget(var1, var2);
            return;
        }
        HoglinAi.maybeRetaliate(var0, var1, var2);
    }

    private static void maybeRetaliate(ServerLevel var0, Hoglin var1, LivingEntity var2) {
        if (var1.getBrain().isActive(Activity.AVOID) && var2.getType() == EntityType.PIGLIN) {
            return;
        }
        if (var2.getType() == EntityType.HOGLIN) {
            return;
        }
        if (BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(var1, var2, 4.0)) {
            return;
        }
        if (!Sensor.isEntityAttackable(var0, var1, var2)) {
            return;
        }
        HoglinAi.setAttackTarget(var1, var2);
        HoglinAi.broadcastAttackTarget(var1, var2);
    }

    private static void setAttackTarget(Hoglin var0, LivingEntity var1) {
        Brain<Hoglin> var2 = var0.getBrain();
        var2.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        var2.eraseMemory(MemoryModuleType.BREED_TARGET);
        var2.setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, var1, 200L);
    }

    private static void broadcastAttackTarget(Hoglin var0, LivingEntity var12) {
        HoglinAi.getVisibleAdultHoglins(var0).forEach(var1 -> HoglinAi.setAttackTargetIfCloserThanCurrent(var1, var12));
    }

    private static void setAttackTargetIfCloserThanCurrent(Hoglin var0, LivingEntity var1) {
        if (HoglinAi.isPacified(var0)) {
            return;
        }
        Optional<LivingEntity> var2 = var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        LivingEntity var3 = BehaviorUtils.getNearestTarget(var0, var2, var1);
        HoglinAi.setAttackTarget(var0, var3);
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(Hoglin var0) {
        return var0.getBrain().getActiveNonCoreActivity().map(var1 -> HoglinAi.getSoundForActivity(var0, var1));
    }

    private static SoundEvent getSoundForActivity(Hoglin var0, Activity var1) {
        if (var1 == Activity.AVOID || var0.isConverting()) {
            return SoundEvents.HOGLIN_RETREAT;
        }
        if (var1 == Activity.FIGHT) {
            return SoundEvents.HOGLIN_ANGRY;
        }
        if (HoglinAi.isNearRepellent(var0)) {
            return SoundEvents.HOGLIN_RETREAT;
        }
        return SoundEvents.HOGLIN_AMBIENT;
    }

    private static List<Hoglin> getVisibleAdultHoglins(Hoglin var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_HOGLINS).orElse((List<Hoglin>)ImmutableList.of());
    }

    private static boolean isNearRepellent(Hoglin var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_REPELLENT);
    }

    private static boolean isBreeding(Hoglin var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET);
    }

    protected static boolean isPacified(Hoglin var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.PACIFIED);
    }
}

