/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public final class ProjectileUtil {
    public static final float DEFAULT_ENTITY_HIT_RESULT_MARGIN = 0.3f;

    public static HitResult getHitResultOnMoveVector(Entity var0, Predicate<Entity> var1) {
        Vec3 var2 = var0.getDeltaMovement();
        Level var3 = var0.level();
        Vec3 var4 = var0.position();
        return ProjectileUtil.getHitResult(var4, var0, var1, var2, var3, ProjectileUtil.computeMargin(var0), ClipContext.Block.COLLIDER);
    }

    public static Either<BlockHitResult, Collection<EntityHitResult>> getHitEntitiesAlong(Entity var0, AttackRange var1, Predicate<Entity> var2, ClipContext.Block var3) {
        Vec3 var4 = var0.getHeadLookAngle();
        Vec3 var5 = var0.getEyePosition();
        Vec3 var6 = var5.add(var4.scale(var1.effectiveMinRange(var0)));
        double var7 = var0.getKnownMovement().dot(var4);
        Vec3 var9 = var5.add(var4.scale((double)var1.effectiveMaxRange(var0) + Math.max(0.0, var7)));
        return ProjectileUtil.getHitEntitiesAlong(var0, var5, var6, var2, var9, var1.hitboxMargin(), var3);
    }

    public static HitResult getHitResultOnMoveVector(Entity var0, Predicate<Entity> var1, ClipContext.Block var2) {
        Vec3 var3 = var0.getDeltaMovement();
        Level var4 = var0.level();
        Vec3 var5 = var0.position();
        return ProjectileUtil.getHitResult(var5, var0, var1, var3, var4, ProjectileUtil.computeMargin(var0), var2);
    }

    public static HitResult getHitResultOnViewVector(Entity var0, Predicate<Entity> var1, double var2) {
        Vec3 var4 = var0.getViewVector(0.0f).scale(var2);
        Level var5 = var0.level();
        Vec3 var6 = var0.getEyePosition();
        return ProjectileUtil.getHitResult(var6, var0, var1, var4, var5, 0.0f, ClipContext.Block.COLLIDER);
    }

    private static HitResult getHitResult(Vec3 var0, Entity var1, Predicate<Entity> var2, Vec3 var3, Level var4, float var5, ClipContext.Block var6) {
        EntityHitResult var9;
        Vec3 var7 = var0.add(var3);
        HitResult var8 = var4.clipIncludingBorder(new ClipContext(var0, var7, var6, ClipContext.Fluid.NONE, var1));
        if (((HitResult)var8).getType() != HitResult.Type.MISS) {
            var7 = var8.getLocation();
        }
        if ((var9 = ProjectileUtil.getEntityHitResult(var4, var1, var0, var7, var1.getBoundingBox().expandTowards(var3).inflate(1.0), var2, var5)) != null) {
            var8 = var9;
        }
        return var8;
    }

    private static Either<BlockHitResult, Collection<EntityHitResult>> getHitEntitiesAlong(Entity var0, Vec3 var1, Vec3 var2, Predicate<Entity> var3, Vec3 var4, float var5, ClipContext.Block var6) {
        Level var7 = var0.level();
        BlockHitResult var8 = var7.clipIncludingBorder(new ClipContext(var1, var4, var6, ClipContext.Fluid.NONE, var0));
        if (var8.getType() != HitResult.Type.MISS && var1.distanceToSqr(var4 = var8.getLocation()) < var1.distanceToSqr(var2)) {
            return Either.left((Object)var8);
        }
        AABB var9 = AABB.ofSize(var2, var5, var5, var5).expandTowards(var4.subtract(var2)).inflate(1.0);
        Collection<EntityHitResult> var10 = ProjectileUtil.getManyEntityHitResult(var7, var0, var2, var4, var9, var3, var5, var6, true);
        if (!var10.isEmpty()) {
            return Either.right(var10);
        }
        return Either.left((Object)var8);
    }

    public static @Nullable EntityHitResult getEntityHitResult(Entity var0, Vec3 var1, Vec3 var2, AABB var3, Predicate<Entity> var4, double var5) {
        Level var7 = var0.level();
        double var8 = var5;
        Entity var10 = null;
        Vec3 var11 = null;
        for (Entity var13 : var7.getEntities(var0, var3, var4)) {
            Vec3 var16;
            double var17;
            AABB var14 = var13.getBoundingBox().inflate(var13.getPickRadius());
            Optional<Vec3> var15 = var14.clip(var1, var2);
            if (var14.contains(var1)) {
                if (!(var8 >= 0.0)) continue;
                var10 = var13;
                var11 = var15.orElse(var1);
                var8 = 0.0;
                continue;
            }
            if (!var15.isPresent() || !((var17 = var1.distanceToSqr(var16 = var15.get())) < var8) && var8 != 0.0) continue;
            if (var13.getRootVehicle() == var0.getRootVehicle()) {
                if (var8 != 0.0) continue;
                var10 = var13;
                var11 = var16;
                continue;
            }
            var10 = var13;
            var11 = var16;
            var8 = var17;
        }
        if (var10 == null) {
            return null;
        }
        return new EntityHitResult(var10, var11);
    }

    public static @Nullable EntityHitResult getEntityHitResult(Level var0, Projectile var1, Vec3 var2, Vec3 var3, AABB var4, Predicate<Entity> var5) {
        return ProjectileUtil.getEntityHitResult(var0, var1, var2, var3, var4, var5, ProjectileUtil.computeMargin(var1));
    }

    public static float computeMargin(Entity var0) {
        return Math.max(0.0f, Math.min(0.3f, (float)(var0.tickCount - 2) / 20.0f));
    }

    public static @Nullable EntityHitResult getEntityHitResult(Level var0, Entity var1, Vec3 var2, Vec3 var3, AABB var4, Predicate<Entity> var5, float var6) {
        double var7 = Double.MAX_VALUE;
        Optional<Object> var9 = Optional.empty();
        Entity var10 = null;
        for (Entity var12 : var0.getEntities(var1, var4, var5)) {
            double var15;
            AABB var13 = var12.getBoundingBox().inflate(var6);
            Optional<Vec3> var14 = var13.clip(var2, var3);
            if (!var14.isPresent() || !((var15 = var2.distanceToSqr(var14.get())) < var7)) continue;
            var10 = var12;
            var7 = var15;
            var9 = var14;
        }
        if (var10 == null) {
            return null;
        }
        return new EntityHitResult(var10, (Vec3)var9.get());
    }

    public static Collection<EntityHitResult> getManyEntityHitResult(Level var0, Entity var1, Vec3 var2, Vec3 var3, AABB var4, Predicate<Entity> var5, boolean var6) {
        return ProjectileUtil.getManyEntityHitResult(var0, var1, var2, var3, var4, var5, ProjectileUtil.computeMargin(var1), ClipContext.Block.COLLIDER, var6);
    }

    public static Collection<EntityHitResult> getManyEntityHitResult(Level var0, Entity var1, Vec3 var2, Vec3 var3, AABB var4, Predicate<Entity> var5, float var6, ClipContext.Block var7, boolean var8) {
        ArrayList<EntityHitResult> var9 = new ArrayList<EntityHitResult>();
        for (Entity var11 : var0.getEntities(var1, var4, var5)) {
            Optional<Vec3> var18;
            Vec3 var16;
            Optional<Vec3> var14;
            AABB var12 = var11.getBoundingBox();
            if (var8 && var12.contains(var2)) {
                var9.add(new EntityHitResult(var11, var2));
                continue;
            }
            Optional<Vec3> var13 = var12.clip(var2, var3);
            if (var13.isPresent()) {
                var9.add(new EntityHitResult(var11, var13.get()));
                continue;
            }
            if ((double)var6 <= 0.0 || (var14 = var12.inflate(var6).clip(var2, var3)).isEmpty()) continue;
            Vec3 var15 = var14.get();
            BlockHitResult var17 = var0.clipIncludingBorder(new ClipContext(var15, var16 = var12.getCenter(), var7, ClipContext.Fluid.NONE, var1));
            if (var17.getType() != HitResult.Type.MISS) {
                var16 = var17.getLocation();
            }
            if (!(var18 = var11.getBoundingBox().clip(var15, var16)).isPresent()) continue;
            var9.add(new EntityHitResult(var11, var18.get()));
        }
        return var9;
    }

    public static void rotateTowardsMovement(Entity var0, float var1) {
        Vec3 var2 = var0.getDeltaMovement();
        if (var2.lengthSqr() == 0.0) {
            return;
        }
        double var3 = var2.horizontalDistance();
        var0.setYRot((float)(Mth.atan2(var2.z, var2.x) * 57.2957763671875) + 90.0f);
        var0.setXRot((float)(Mth.atan2(var3, var2.y) * 57.2957763671875) - 90.0f);
        while (var0.getXRot() - var0.xRotO < -180.0f) {
            var0.xRotO -= 360.0f;
        }
        while (var0.getXRot() - var0.xRotO >= 180.0f) {
            var0.xRotO += 360.0f;
        }
        while (var0.getYRot() - var0.yRotO < -180.0f) {
            var0.yRotO -= 360.0f;
        }
        while (var0.getYRot() - var0.yRotO >= 180.0f) {
            var0.yRotO += 360.0f;
        }
        var0.setXRot(Mth.lerp(var1, var0.xRotO, var0.getXRot()));
        var0.setYRot(Mth.lerp(var1, var0.yRotO, var0.getYRot()));
    }

    public static InteractionHand getWeaponHoldingHand(LivingEntity var0, Item var1) {
        return var0.getMainHandItem().is(var1) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static AbstractArrow getMobArrow(LivingEntity var0, ItemStack var1, float var2, @Nullable ItemStack var3) {
        ArrowItem var4 = (ArrowItem)(var1.getItem() instanceof ArrowItem ? var1.getItem() : Items.ARROW);
        AbstractArrow var5 = var4.createArrow(var0.level(), var1, var0, var3);
        var5.setBaseDamageFromMob(var2);
        return var5;
    }
}

